/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    stm32f0xx_it.c
  * @brief   Interrupt Service Routines.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "stm32f0xx_it.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN TD */

uint32_t counter=0;

uint32_t get_millis(void)
{
  return counter;
}
/* USER CODE END TD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
 
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */
void  USART1_RX_Callback(void);
void Set_Prog_Timer(uint8_t n_prog, uint32_t timer);
void EXTI1_Callback(uint8_t pin);
void EXTI0_Callback(uint32_t delay);
void TIM14_Callback(void);
void DMA1_USART_TXComplete(void);
void DMA1_SPI_TXComplete(void);

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/* External variables --------------------------------------------------------*/

/* USER CODE BEGIN EV */

/* USER CODE END EV */

/******************************************************************************/
/*           Cortex-M0 Processor Interruption and Exception Handlers          */
/******************************************************************************/
/**
  * @brief This function handles Non maskable interrupt.
  */
void NMI_Handler(void)
{
  /* USER CODE BEGIN NonMaskableInt_IRQn 0 */

  /* USER CODE END NonMaskableInt_IRQn 0 */
  /* USER CODE BEGIN NonMaskableInt_IRQn 1 */

  /* USER CODE END NonMaskableInt_IRQn 1 */
}

/**
  * @brief This function handles Hard fault interrupt.
  */
void HardFault_Handler(void)
{
  /* USER CODE BEGIN HardFault_IRQn 0 */

  /* USER CODE END HardFault_IRQn 0 */
  while (1)
  {
    /* USER CODE BEGIN W1_HardFault_IRQn 0 */
    /* USER CODE END W1_HardFault_IRQn 0 */
  }
}

/**
  * @brief This function handles System service call via SWI instruction.
  */
void SVC_Handler(void)
{
  /* USER CODE BEGIN SVC_IRQn 0 */

  /* USER CODE END SVC_IRQn 0 */
  /* USER CODE BEGIN SVC_IRQn 1 */

  /* USER CODE END SVC_IRQn 1 */
}

/**
  * @brief This function handles Pendable request for system service.
  */
void PendSV_Handler(void)
{
  /* USER CODE BEGIN PendSV_IRQn 0 */

  /* USER CODE END PendSV_IRQn 0 */
  /* USER CODE BEGIN PendSV_IRQn 1 */

  /* USER CODE END PendSV_IRQn 1 */
}

/**
  * @brief This function handles System tick timer.
  */
void SysTick_Handler(void)
{
  /* USER CODE BEGIN SysTick_IRQn 0 */
   counter++;
  /* USER CODE END SysTick_IRQn 0 */

  /* USER CODE BEGIN SysTick_IRQn 1 */

  /* USER CODE END SysTick_IRQn 1 */
}

/******************************************************************************/
/* STM32F0xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32f0xx.s).                    */
/******************************************************************************/

/**
  * @brief This function handles EXTI line 0 and 1 interrupts.
  */
void EXTI0_1_IRQHandler(void)
{
  /* USER CODE BEGIN EXTI0_1_IRQn 0 */

  /* USER CODE END EXTI0_1_IRQn 0 */
  if (LL_EXTI_IsActiveFlag_0_31(LL_EXTI_LINE_0) != RESET)
  {
    LL_EXTI_ClearFlag_0_31(LL_EXTI_LINE_0);
    /* USER CODE BEGIN LL_EXTI_LINE_0 */
		static uint32_t tickstart = 10;
		static uint8_t f_set = 0;
		uint32_t tickstop;
		uint8_t pin = (uint8_t) (LL_GPIO_IsInputPinSet(ecode_Kn_GPIO_Port,ecode_Kn_Pin));

		if (pin == 0 && f_set == 0)
		{
			f_set = 1;
			tickstart = get_millis();
			LL_mDelay(10); // 
		}
		else 	if (pin != 0 && f_set == 1) //
				{
					f_set = 0;
					tickstop = get_millis() - tickstart;
					EXTI0_Callback(tickstop);
				}

    /* USER CODE END LL_EXTI_LINE_0 */
  }
  if (LL_EXTI_IsActiveFlag_0_31(LL_EXTI_LINE_1) != RESET)
  {
    LL_EXTI_ClearFlag_0_31(LL_EXTI_LINE_1);
    /* USER CODE BEGIN LL_EXTI_LINE_1 */

	EXTI1_Callback(LL_GPIO_IsInputPinSet(GPIOF, LL_GPIO_PIN_0));

    /* USER CODE END LL_EXTI_LINE_1 */
  }
  /* USER CODE BEGIN EXTI0_1_IRQn 1 */

  /* USER CODE END EXTI0_1_IRQn 1 */
}

/**
  * @brief This function handles DMA1 channel 2 and 3 interrupts.
  */
void DMA1_Channel2_3_IRQHandler(void)
{
  /* USER CODE BEGIN DMA1_Channel2_3_IRQn 0 */

	if(LL_DMA_IsActiveFlag_TC2(DMA1))//  USART  OK
	  {
	    LL_DMA_ClearFlag_TC2(DMA1);
	    DMA1_USART_TXComplete();
	  }
	else  if(LL_DMA_IsActiveFlag_TE2(DMA1))////
	        {
				LL_DMA_ClearFlag_TE2(DMA1);
	         //LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_2);
	        }

  /* USER CODE END DMA1_Channel2_3_IRQn 0 */

  /* USER CODE BEGIN DMA1_Channel2_3_IRQn 1 */
	if(LL_DMA_IsActiveFlag_TC3(DMA1))//  SPI  OK
		  {
		    LL_DMA_ClearFlag_TC3(DMA1);
		    DMA1_SPI_TXComplete();
		  }
		else  if(LL_DMA_IsActiveFlag_TE3(DMA1))//
		        {
					LL_DMA_ClearFlag_TE3(DMA1);
		         //LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_3);
		        }
  /* USER CODE END DMA1_Channel2_3_IRQn 1 */
}

/**
  * @brief This function handles TIM14 global interrupt.
  */
void TIM14_IRQHandler(void)
{
  /* USER CODE BEGIN TIM14_IRQn 0 */
	//TIM14->SR &= ~ TIM_SR_UIF;
	LL_TIM_ClearFlag_UPDATE(TIM14);
	TIM14_Callback();
  /* USER CODE END TIM14_IRQn 0 */
  /* USER CODE BEGIN TIM14_IRQn 1 */

  /* USER CODE END TIM14_IRQn 1 */
}

/**
  * @brief This function handles USART1 global interrupt.
  */
void USART1_IRQHandler(void)
{
  /* USER CODE BEGIN USART1_IRQn 0 */

	if(LL_USART_IsActiveFlag_RXNE(USART1) && LL_USART_IsEnabledIT_RXNE(USART1))
	  {
	   USART1_RX_Callback();
	  }
	else
	  {
	   if(LL_USART_IsActiveFlag_ORE(USART1))
		{
		 (void) USART1->RDR;
		 LL_USART_ClearFlag_ORE(USART1);
		}
	   else if(LL_USART_IsActiveFlag_FE(USART1))
			 {
			  (void) USART1->RDR;
			  LL_USART_ClearFlag_FE(USART1);
			 }
		   else if(LL_USART_IsActiveFlag_NE(USART1))
			     {
			      (void) USART1->RDR;
			      LL_USART_ClearFlag_NE(USART1);
			     }
	  }
  /* USER CODE END USART1_IRQn 0 */
  /* USER CODE BEGIN USART1_IRQn 1 */

  /* USER CODE END USART1_IRQn 1 */
}

/* USER CODE BEGIN 1 */

/* USER CODE END 1 */
