package com.example.car_8266_xyz;

import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RadioGroup;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

//------------------------------------------------------------------

import java.util.Timer;
import java.util.TimerTask;




public class MainActivity extends AppCompatActivity
{
    private Connection  mConnect  = null;
    private  String     IPAddress      = "192.168.1.130";
    private  int        PortNumber      = 9876;
    private EditText ipEdit     = null;
    private EditText portEdit     = null;

    private  TextView textViewStat;

    private SeekBar seekBarL, seekBarR, seekBar_trim;

    private int trim = 20;

    private int progressL = 255, progressR = 255;
    private byte Yes_connect = 0;

    // общие объекты параметров, используемые для сохранения IP адреса и порта, чтобы
    // пользователь не вводил их в следующий раз, когда он открывает приложение
    // это будет именем файла настроек
    public static final String PREFS_FILE = "prefs_file";

    //ключи
    private static final String PREF_IP = "pref_IP";
    private static final String PREF_PORT = "pref_PORT";
    //экземпляр класса SharedPreferences:
    SharedPreferences mSettings;
    SharedPreferences.Editor prefEditor;

    //----------------------------------------------------------------------

    private SensorManager mSensorManager;
    private Sensor mOrientation;

    private final boolean Ver = true;
    private final boolean Hor = false;
    private boolean   Orientation = Ver;

    private float xy_angle;
    private float xz_angle;

    private int x;
    private int y;

    private int z;

    private TextView xyView;
    private TextView xzView;
    private TextView zyView;



    private TextView textView_ch;

    Timer timer;

    private CheckedTextView checkTV_naklon;

    private boolean check_naklon = false;

    private FrameLayout frameLayoutXYZ;

    private float srX=0, srY=0, sumX=0, sumY=0, dif;

    Button buttonConnect;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        EdgeToEdge.enable(this);
        setContentView(R.layout.activity_main);

        TextView textViewL = findViewById(R.id.textViewL);
        seekBarL= (SeekBar) findViewById(R.id.seekBarL);
        seekBarL.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener()
        {
            @Override
            public void onProgressChanged(SeekBar seekBarL, int progress, boolean fromUser) {

                //progressL=progress;
                int PL = progress - 255;
                progressL = (PL * trim) / 40 + 255;

                textViewL.setText(String.valueOf(progressL - 255));

                sendAll ();
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBarL) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBarL) {
            }
        });


        TextView textViewR = findViewById(R.id.textViewR);
        seekBarR= (SeekBar) findViewById(R.id.seekBarR);
        seekBarR.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener()
        {
            @Override
            public void onProgressChanged(SeekBar seekBarR, int progress, boolean fromUser) {

                //progressR=progress;
                int PR = progress - 255;
                progressR = (PR * trim) / 40 + 255;

                textViewR.setText(String.valueOf(progressR - 255));

                sendAll ();
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBarR) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBarR) {
            }
        });

        textView_ch = findViewById(R.id.textView_ch);

        seekBar_trim= (SeekBar) findViewById(R.id.seekBar_trim);
        seekBar_trim.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){
            @Override
            public void onProgressChanged(SeekBar seekBar_trim, int progress, boolean fromUser) {

                trim = progress;
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar_trim) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar_trim) {

            }
        });

        frameLayoutXYZ  = findViewById(R.id.frameLayoutXYZ);

        // Обработка нажатия кнопки Stop
        Button buttonStop = findViewById(R.id.buttonStop);
        buttonStop.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                SeekBar seekBarL= (SeekBar) findViewById(R.id.seekBarL);
                seekBarL.setProgress(255);

                SeekBar seekBarR= (SeekBar) findViewById(R.id.seekBarR);
                seekBarR.setProgress(255);
//отключение управление наклоном
                checkTV_naklon.setChecked(false);
                checkTV_naklon.setCheckMarkDrawable(android.R.drawable.checkbox_off_background);
                check_naklon = false;

                //textView_ch.setVisibility(View.INVISIBLE);
                //seekBar_trim.setVisibility(View.INVISIBLE);
                frameLayoutXYZ.setVisibility(View.INVISIBLE);
            }
        });


        // Обработка нажатия кнопки Connect
        buttonConnect = findViewById(R.id.buttonConnect);
        buttonConnect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onOpenClick();
            }

        });

        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        ipEdit     = (EditText) findViewById(R.id.editTextIPAddress);
        portEdit     = (EditText) findViewById(R.id.editTextPortNumber);


        textViewStat = (TextView)findViewById(R.id.textViewStat);

        //Получение сохраненных данных
        mSettings =  getSharedPreferences(PREFS_FILE, MODE_PRIVATE);

        IPAddress = mSettings.getString(PREF_IP,"192.168.1.130");
        ipEdit.setText(IPAddress);

        PortNumber = mSettings.getInt(PREF_PORT,9876);
        portEdit.setText(String.valueOf(PortNumber));

        //---------------------------------------------------------------------------------------
        mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE); // Получаем менеджер сенсоров
        mOrientation = mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER); // Получаем датчик положения

        xyView = (TextView) findViewById(R.id.textViewX);  //
        xzView = (TextView) findViewById(R.id.textViewY);  // Наши текстовые поля для вывода показаний
        zyView = (TextView) findViewById(R.id.textViewZ);// сюда пихнем "direction"

        checkTV_naklon = findViewById(R.id.checkedTV_naklon);
        checkTV_naklon.setOnClickListener(new View.OnClickListener() {
            @Override public void onClick(View view) {
                if (checkTV_naklon.isChecked()) {
                    checkTV_naklon.setChecked(false);
                    checkTV_naklon.setCheckMarkDrawable(android.R.drawable.checkbox_off_background);
                    check_naklon = false;

                    //textView_ch.setVisibility(View.INVISIBLE);
                    //seekBar_trim.setVisibility(View.INVISIBLE);
                    frameLayoutXYZ.setVisibility(View.INVISIBLE);

                } else {
                    checkTV_naklon.setChecked(true);
                    checkTV_naklon.setCheckMarkDrawable(android.R.drawable.checkbox_on_background);
                    check_naklon = true;

                    //textView_ch.setVisibility(View.VISIBLE);
                    //seekBar_trim.setVisibility(View.VISIBLE);
                    frameLayoutXYZ.setVisibility(View.VISIBLE);
                }
            }
        });

        //textView_ch.setVisibility(View.INVISIBLE);
        //seekBar_trim.setVisibility(View.INVISIBLE);
        frameLayoutXYZ.setVisibility(View.INVISIBLE);

        //setRequestedOrientation (ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); //для альбомного режима

        //Орентация для портретного режима
        setRequestedOrientation (ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

        RadioGroup radioGroup = findViewById(R.id.radioGroup_Or);

        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                // Получаем ID выбранной радиокнопки

                //Закрытие соединения
                if(Yes_connect == 1) {
                    mConnect.closeConnection();
                }

                //Отключение управления наклоном
                checkTV_naklon.setChecked(false);
                checkTV_naklon.setCheckMarkDrawable(android.R.drawable.checkbox_off_background);
                check_naklon = false;

                //textView_ch.setVisibility(View.INVISIBLE);
                //seekBar_trim.setVisibility(View.INVISIBLE);
                frameLayoutXYZ.setVisibility(View.INVISIBLE);

                if(checkedId == R.id.radioButtonV)
                {// Обработка события выбора вертикальная
                    setRequestedOrientation (ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                    Orientation = Ver;
                }

                if(checkedId == R.id.radioButtonH)
                {// Обработка события выбора горизонтальная
                    setRequestedOrientation (ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                    Orientation = Hor;
                }
            }
        });

    }//  onCreate



    void sendAll ()
    {
        if (mConnect == null)
        {
            Log.d(Connection.LOG_TAG, "Соединение не установлено");
            textViewStat.setTextColor(Color.RED);
            textViewStat.setText("   Нет соединения");//Для контроля

        }
        else
        {
            //Log.d(Connection.LOG_TAG, "Отправка сообщения");
            new Thread(new Runnable()
            {
                @Override
                public void run()
                {
                    try{
                        int pL= (progressL < 255) ? (255 - progressL) : (progressL - 255);
                        int pR= (progressR < 255) ? (255 - progressR) : (progressR - 255);

                        String str= "#" + String.format("%02X", pL) + String.format("%02X", pR) +
                                ((progressL < 255) ? "-" : "+")  +  ((progressR < 255) ? "-" : "+") ;

                        // отправляем на сервер данные
                        mConnect.sendData(str.getBytes());
                    } catch (Exception e) {
                        Log.e(Connection.LOG_TAG, e.getMessage());

                        textViewStat.setTextColor(Color.RED);
                        //textViewStat.setBackgroundColor(Color.RED);
                        textViewStat.setText("   Нет соединения");//Для контроля
                    }
                }
            }).start();
        }
    }

    @Override
    protected void onPause(){
        super.onPause();

        IPAddress = ipEdit.getText().toString();
        // сохраняем в настройках
        prefEditor = mSettings.edit();
        prefEditor.putString(PREF_IP, IPAddress);
        prefEditor.apply();

        String port= portEdit.getText().toString().trim();

        if(port.length() < 4) PortNumber = 9876;
        else  PortNumber = Integer.parseInt(port);
        
        // сохраняем в настройках
        prefEditor = mSettings.edit();
        prefEditor.putInt(PREF_PORT, PortNumber);
        prefEditor.apply();
    }

    private void onOpenClick()
    {
        if(Yes_connect == 1) {
            mConnect.closeConnection();

            buttonConnect.setText("Connect");
            Yes_connect = 0;

            textViewStat.setTextColor(Color.RED);
            textViewStat.setText("    Нет соединения");

            return;
        }

        Yes_connect=0;

        // Создание подключения
        IPAddress = ipEdit.getText().toString().trim();
        if(IPAddress.length() < 8)
        {
            IPAddress="192.168.1.130";
            ipEdit.setText(IPAddress);
        }

        String port= portEdit.getText().toString().trim();
        if(port.length() < 2)
        {
            PortNumber = 9876;
            portEdit.setText("9876");
        }
        else
        {
            PortNumber = Integer.parseInt(port);
        }

        textViewStat.setTextColor(Color.BLACK);
        textViewStat.setText(IPAddress);//Для контроля

        mConnect = new Connection(IPAddress, PortNumber);

        // Открытие сокета в отдельном потоке
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    mConnect.openConnection();
                    // Разблокирование кнопок в UI потоке
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            //mBtnSend.setEnabled(true);
                            //mBtnClose.setEnabled(true);
                        }
                    });
                    Log.d(Connection.LOG_TAG, "Соединение установлено");
                    Log.d(Connection.LOG_TAG, "(mConnect != null) = " + (mConnect != null));

                    textViewStat.setTextColor(Color.BLACK);
                    textViewStat.setText("Соединение установлено");//Для контроля

                    buttonConnect.setText("DesConnect");
                    Yes_connect=1;

                } catch (Exception e) {
                    Log.e(Connection.LOG_TAG, e.getMessage());
                    mConnect = null;

                    //Resources resources = getResources();
                    //int colorMy = resources.getColor(R.color.textViewRed,null);

                    //textViewStat.setTextColor(getResources().getColor(R.color.textViewRed,null));

                    textViewStat.setTextColor(Color.RED);
                    textViewStat.setText("    Нет соединения");
                    buttonConnect.setText("Connect");
                    Yes_connect=0;
                    //Toast toast = Toast.makeText(getApplicationContext(), "Нет соединения",Toast.LENGTH_LONG);
                    //toast.show();
                }
            }
        }).start();
    }

    //-----------------------------------------------------------
    @Override
    protected void onResume() {
        super.onResume();

        mSensorManager.registerListener(listener, mOrientation,
                SensorManager.SENSOR_DELAY_NORMAL);


        timer = new Timer();
        TimerTask task = new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        showInfo();
                    }
                });
            }
        };
        timer.schedule(task, 0, 400);
    }

    void showInfo() {
        /*
        xyView.setText("x = " + String.format("%.1f", valuesAccel[0]));
        xzView.setText("y = " + String.format("%.1f", valuesAccel[1]));
        zyView.setText("z = " + String.format("%.1f", valuesAccel[2]));
         */

        xyView.setText("x = " + String.valueOf(x));
        xzView.setText("y = " + String.valueOf(y));
        zyView.setText("z = " + String.valueOf(z));
    }

    float[] valuesAccel = new float[3];
    //float[] valuesAccelMotion = new float[3];
    //float[] valuesAccelGravity = new float[3];
    float[] valuesLinAccel = new float[3];
    float[] valuesGravity = new float[3];

    SensorEventListener listener = new SensorEventListener() {
        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        @Override
        public void onSensorChanged(SensorEvent event)
        {
            switch (event.sensor.getType())
            {
                case Sensor.TYPE_ACCELEROMETER: // Получаем датчик положения
                    for (int i = 0; i < 3; i++)
                    {
                        valuesAccel[i] = event.values[i];// * trim;

                        //valuesAccelGravity[i] = (float) (0.1 * event.values[i] + 0.9 * valuesAccelGravity[i]);
                        //valuesAccelMotion[i] = event.values[i] - valuesAccelGravity[i];
                    }

                    /*
                    x   =   (int)valuesAccel[0];
                    y   =   (int)valuesAccel[1];
                    */
                    z   =   (int)valuesAccel[2];

                //скользящее среднее
                    dif = valuesAccel[0] - srX;
                    sumX = sumX + dif;
                    srX = sumX / 2;
                    x   = (int)(srX * trim);

                    dif = valuesAccel[1] - srY;
                    sumY = sumY + dif;
                    srY = sumY / 2;
                    y   = (int)(srY * trim);

                    if(check_naklon == true)
                    {
                        if(Orientation == Ver)
                        {
                            int l = 255 - y - x;
                            int r = 255 - y + x;
                            if (l > 510) l = 510;
                            if (l < 0) l = 0;
                            if (r > 510) r = 510;
                            if (r < 0) r = 0;
                            seekBarL.setProgress(l);
                            seekBarR.setProgress(r);
                        }
                        else
                        {
                            int l = 255 - x + y;
                            int r = 255 - x - y;
                            if (l > 510) l = 510;
                            if (l < 0) l = 0;
                            if (r > 510) r = 510;
                            if (r < 0) r = 0;
                            seekBarL.setProgress(l);
                            seekBarR.setProgress(r);

                        }
                    }
                    break;

                case Sensor.TYPE_LINEAR_ACCELERATION:
                    for (int i = 0; i < 3; i++) {
                        valuesLinAccel[i] = event.values[i];
                    }
                    break;

                case Sensor.TYPE_GRAVITY:
                    for (int i = 0; i < 3; i++) {
                        valuesGravity[i] = event.values[i];
                    }
                    break;
            }

        }
    };//SensorEventListener


}