const int dataPin  = A0;  // Q7
const int clockPin = A2;  // CP
const int loadPin  = A3;  // PL#
const int mrPin    = A1;  // MR#
const int numBits  = 8;   // 8 бит = один регистр

void setup() {
  Serial.begin(9600);

  pinMode(dataPin, INPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(loadPin, OUTPUT);
  pinMode(mrPin, OUTPUT);

  digitalWrite(clockPin, LOW);
  digitalWrite(loadPin, HIGH);
  digitalWrite(mrPin, HIGH);
}

void loop() {
  digitalWrite(loadPin, LOW);
  delayMicroseconds(5);
  digitalWrite(loadPin, HIGH);
  delayMicroseconds(5);

  byte portState = 0;
  for (int i = 0; i < numBits; i++) {
    int bit = digitalRead(dataPin);
    portState |= (bit ? 1 : 0) << (numBits - 1 - i);  // MSB first

    digitalWrite(clockPin, HIGH);
    delayMicroseconds(2);
    digitalWrite(clockPin, LOW);
    delayMicroseconds(2);
  }

  Serial.print("Port state: ");
  for (int i = numBits - 1; i >= 0; i--)
    Serial.print((portState >> i) & 1);

  Serial.println();

  delay(200);
}
