.include "tn13def.inc"

;     
.equ MODE0_VALUE = 10 * 255 / 100
.equ MODE1_VALUE = 20 * 255 / 100
.equ MODE2_VALUE = 50 * 255 / 100
.equ MODE3_VALUE = 100 * 255 / 100

;  
.equ F_CPU = 1200000
;     (100 )
.equ SWITCH_DELAY = int(F_CPU * 0.1 / 10)

.def tmp = r16
.def mode = r17

.cseg

.macro until_eeprom_ready
wait:
	sbic EECR,EEPE
	rjmp wait
.endm

.org 0
	rjmp reset

;-------------------------------------------------------------------------------
;      (PB1: high -> low)

.org INT0addr

;   
	inc mode
	andi mode,3
	rcall update_mode

;     EEPROM
	until_eeprom_ready
	ldi tmp,ee_mode
	out EEARL,tmp
	out EEDR,mode
	sbi EECR,EEMPE
	sbi EECR,EEPE

;   
;   (10 * SWITCH_DELAY)  
	ldi xh,high(SWITCH_DELAY)
	ldi xl,low(SWITCH_DELAY)
wait:
	sbiw xh:xl,1
	nop
	nop
	nop
	nop
	nop
	nop
	brne wait
		
	reti

;    ,   'mode'
update_mode:
	cpi mode,1
	breq set_mode1
	cpi mode,2
	breq set_mode2
	cpi mode,3
	breq set_mode3
	ldi tmp,MODE0_VALUE
	rjmp set_ocr
set_mode1:
	ldi tmp,MODE1_VALUE
	rjmp set_ocr
set_mode2:
	ldi tmp,MODE2_VALUE
	rjmp set_ocr
set_mode3:
	ldi tmp,MODE3_VALUE
set_ocr:
	out OCR0A,tmp
	ret

;-------------------------------------------------------------------------------
;  

reset:

;   
	ldi tmp,RAMEND
	out SPL,tmp

;  SLEEP, INT0  
	ldi tmp,1<<SE|1<<ISC01
	out MCUCR,tmp

;     EEPROM:0
	until_eeprom_ready
	ldi tmp,ee_mode
	out EEARL,tmp
	sbi EECR,EERE
	in mode,EEDR
	cpi mode,4
	brlo apply_initial_mode
;   EEPROM    ,
;    0  
	clr mode
apply_initial_mode:
	rcall update_mode
	
;   = F_CPU / (256 * 8)
	ldi tmp,1<<CS01
	out TCCR0B,tmp
	
; fast PWM,  
	ldi tmp,1<<COM0A1|1<<WGM00|1<<WGM01
	out TCCR0A,tmp

;  
	sbi DDRB,PB0

;  INT0
	ldi tmp,1<<INT0
	out GIMSK,tmp

;  
	sei
idle:
	sleep
	rjmp idle

;-------------------------------------------------------------------------------
;  EEPROM

.eseg
.org 0

;  
ee_mode:	.db 0
