//
//      tn2313t.c
//
//--------------------------------------------------------------

#include <avr/interrupt.h> //  

//--------------------------------------------------------------

typedef void(*fnptr)();

#define spmaskdat 0x11
#define blank_a 0xF0
#define blank_b 0x0F
#define outport PORTB
#define hastep 4
#define tmdiv 128
#define hasm0 1
#define hasm2 0b01000000 

volatile uint8_t spmask, tmpd, tmpa, tmpb, scnt, pcnt, lcnt, isf;

fnptr refptr;

uint8_t vram[8];

void point();
void darkslot();
void linstart2();
void ledmod();

union {
 uint64_t bigdat;
 struct {
     uint8_t vdat0;
     uint8_t vdat1;
     uint8_t vdat2;
     uint8_t vdat3;
     uint8_t vdat4;
     uint8_t vdat5;
     uint8_t vdat6;
     uint8_t vdat7;
	    }lowdat;
} recodum;

//------------------------------------------------

int main()
{

  outport = 0; DDRB = 0xFF;
  //refptr = point; //!!!***!!!
  lcnt = 3; darkslot();
  cli();
  CLKPR = 1 << CLKPCE; CLKPR = 0;
  TCCR0A = 1 << WGM01; OCR0A = tmdiv;  
  TCCR0B = 1 << CS00;
  TIMSK = 1 << OCIE0A;
  sei();

  while(1){if(isf){refptr();}}

}

//------------------------------------------------

void point()
{
 outport = tmpd; scnt++;
 if(scnt)
  {
   if(tmpa < scnt){tmpd = tmpd & blank_a;}
   if(tmpb < scnt){tmpd = tmpd & blank_b;}
  }
  else
   {
    pcnt++;
    if(pcnt < 4){spmask = spmask << 1; linstart2();}
    else{refptr = darkslot;}
   }
 isf = 0;
}

void darkslot()
{
 outport = 0; lcnt++;
 if(lcnt == hastep){ledmod();lcnt = 0;}
 pcnt = 0; spmask = spmaskdat; refptr = point;
 linstart2(); isf = 0;
}

void linstart2()
{
 tmpa = vram[pcnt]; tmpb = vram[(pcnt+4)]; tmpd = spmask;
 if(tmpa == 0){tmpd = tmpd & blank_a;}
 if(tmpd == 0){tmpd = tmpd & blank_b;}
 scnt = 1;
}

void ledmod()
{
 recodum.lowdat.vdat0 = vram[0]; recodum.lowdat.vdat1 = vram[1];
 recodum.lowdat.vdat2 = vram[2]; recodum.lowdat.vdat3 = vram[3];
 recodum.lowdat.vdat4 = vram[4]; recodum.lowdat.vdat5 = vram[5];
 recodum.lowdat.vdat6 = vram[6]; recodum.lowdat.vdat7 = vram[7];
 if(recodum.bigdat == 0){recodum.bigdat = UINT64_MAX;}
 tmpa = recodum.lowdat.vdat0 & hasm0;
 if(tmpa){tmpa = 0xFF;}
 tmpb = recodum.lowdat.vdat2 & hasm2;
 if(tmpb){tmpb = 0xFF;}
 tmpa = tmpa ^ tmpb;
 recodum.bigdat = recodum.bigdat >> 1;
 vram[0] = recodum.lowdat.vdat0; vram[1] = recodum.lowdat.vdat1;
 vram[2] = recodum.lowdat.vdat2; vram[3] = recodum.lowdat.vdat3;
 vram[4] = recodum.lowdat.vdat4; vram[5] = recodum.lowdat.vdat5;
 vram[6] = recodum.lowdat.vdat6; vram[7] = recodum.lowdat.vdat7;
 if(tmpa){vram[7] |= 1 << 7;}
  else {vram[7] &= ~(1 << 7);}
}

ISR(TIMER0_COMPA_vect){isf = 1;}

//------------------------------------------------

//------------- /end of file---------------------
