   1                     ;   "defines.inc"    ,
   2                     ;     
   3                     
   4                     ;  - (  X)
   5                     
   6                     ;     
   7                     ; void _delay_ms(unsigned int delay)
   8                     	xref __delay_ms
   9                     	
  10                     ;      
  11                     ; void _delay_us10(unsigned int delay)
  12                     	xref __delay_us10
  13                     	
   1                     ;   : defines.inc
   2                     ;      :
   3                     ; lcd.asm -      .
   4                     ; delay.asm -  .
   5                     
   6                     	;  
   7                     ;	#include "stm8s105c6.inc"
   8                     
  10       00000001      	#define _DEFINES_INC
  11                     	
  12       007a1200      	#define __CPU_CLOCK 8000000 ;      
  13                     	;    444444    delay_xx  
  14                     	
  15                     	;       
  16                     					; PORT_A3-6 - Data4-7
  17                     					; PORT_E7 - RS
  18                     					; PORT_E6 - Enable
  19                     					; PORT_B7 - R/#W
  20       00005000      __LCD_DATA_PORT: equ $5000 ;PA_ODR
  21                     	
  22                     	;       
  23                     	;        
  24       00000001      __LCD_DATA_SHIFT:	equ	1		;   1  (  3-6)
  25                     	
  26                     	;     ,   
  27                     	;   
  28       00005014      __LCD_RS_PORT: equ $5014 ;PE_ODR  ;  RS (/)
  29       00000007      __LCD_RS_BIT:	equ 7
  30                     	
  31       00005014      __LCD_E_PORT: equ $5014 ;PE_ODR		;   ()
  32       00000006      __LCD_E_BIT: equ 6
  33                     	
  34       00005005      __LCD_RW_PORT: equ $5005 ;PB_ODR	;  R/#W (/)
  35       00000007      __LCD_RW_BIT: equ 7
  36                     
   3                     
   4                     	switch	.bsct
   5                     
   6  0000               __LCD_X:			;     
   7  0000 00            	ds.b	1
   8  0001               __LCD_Y:	 		;    
   9  0001 00            	ds.b	1
  10  0002               __LCD_X_MAX:	;     
  11  0002 00            	ds.b	1
  12                     
  13                     	switch	.text
  14                     
  15                     ;   "defines.inc"      
  16                     					; PORT_A3-6 - Data4-7
  17                     					; PORT_E7 - RS
  18                     					; PORT_E6 - Enable
  19                     					; PORT_B7 - R/#W
  20                     	;#define LCD_DATA_PORT PA_ODR
  21                     	
  22                     	;       
  23                     	;        
  24                     	;#define LCD_DATA_SHIFT 1		;   1  (  3-6)
  25                     
  26                     ;      
  27       00000078      __LCD_DATA_MASK:	equ	$F0 >> __LCD_DATA_SHIFT ;LCD_DATA_MASK=0xF0>>LVD_DATA_SHIFT
  28       ffffff87      __LCD_DATA_MASK_NOT:	equ	~__LCD_DATA_MASK
  29                     	
  30                     	;     ,   
  31                     	;   
  32                     	;#define LCD_RS_PORT PE_ODR
  33                     	;#define LCD_RS_BIT 7
  34                     	;#define LCD_E_PORT PE_ODR
  35                     	;#define LCD_E_BIT 6
  36                     	;#define LCD_RW_PORT PB_ODR
  37                     	;#define LCD_RW_BIT 7
  38                     
  39                     ;    
  40                     ; :  -    ( 0-3)
  41                     ;    A, CC
  42  0000               lcd_write_nibble:	;   A -  ( 0-3)
  43  0000 721f5005      	bres __LCD_RW_PORT, #__LCD_RW_BIT		;   RW=0
  44                     	;        
  45                     	; (      )
  47  0004 48            	sll	A
  50  0005 48            	sll	A
  53  0006 48            	sll	A
  58                     	
  59  0007 a478          	and	A,#__LCD_DATA_MASK	;    
  60  0009 88            	push	A									;   
  61  000a c65000        	ld	A, __LCD_DATA_PORT	; ,     
  62  000d a487          	and A,#__LCD_DATA_MASK_NOT	;  "" 
  63  000f 1a01          	or	A,(1,SP)							;   
  64  0011 c75000        	ld	__LCD_DATA_PORT, A			;     
  65  0014 a678          	ld	A, #__LCD_DATA_MASK			; 
  66  0016 ca5002        	or	A, __LCD_DATA_PORT+2	;      DDR
  67  0019 c75002        	ld	__LCD_DATA_PORT+2, A	;      (DDR)
  68  001c 721c5014      	bset __LCD_E_PORT, #__LCD_E_BIT	;  E=1
  69  0020 9d            	nop		;   437,5 ns (  16 MHz)
  70  0021 9d            	nop
  71  0022 9d            	nop
  72  0023 9d            	nop
  73  0024 9d            	nop
  74  0025 9d            	nop
  75  0026 5b01          	addw	SP,#1
  76  0028 721d5014      	bres __LCD_E_PORT, #__LCD_E_BIT		;  E=0
  77  002c 81            	ret
  78                     	
  79                     ;  .      
  80                     ; : 
  81                     ;    A, CC
  82  002d               lcd_read_nibble:
  83  002d a687          	ld	A, #__LCD_DATA_MASK_NOT		; 
  84  002f c45002        	and	A, __LCD_DATA_PORT+2 		;       DDR
  85  0032 c75002        	ld	__LCD_DATA_PORT+2, A		;    
  86  0035 721e5005      	bset __LCD_RW_PORT, #__LCD_RW_BIT		; : RW=1
  87  0039 9d            	nop													;  62ns ( 16 MHz)
  88  003a 721c5014      	bset __LCD_E_PORT, #__LCD_E_BIT	;  E=1
  89  003e 9d            	nop													;  250ns ( 16 MHz)
  90  003f 9d            	nop
  91  0040 9d            	nop
  92  0041 9d            	nop
  93  0042 c65001        	ld	A, __LCD_DATA_PORT+1 		;   (IDR)
  94  0045 a478          	and A, #__LCD_DATA_MASK				;  "" 
  95                     	;   ,      0-3
  96                     	;    
  98  0047 44            	srl A
 101  0048 44            	srl A
 104  0049 44            	srl	A
 109                     	
 110  004a 9d            	nop			;  125ns ( 16MHz)
 111  004b 9d            	nop
 112                     
 113  004c 721d5014      	bres __LCD_E_PORT, #__LCD_E_BIT		;  E=0
 114                     
 115  0050 81            	ret		; ,  . A -   (  0-3)
 116                     	
 117                     ;       DDRAM
 118                     ; : 
 119                     ;      
 120                     ;    A, CC
 121                     	xdef	__lcd_read_status
 122  0051               __lcd_read_status:		; unsigned char _lcd_read_status(void)
 123  0051 721f5014      	bres __LCD_RS_PORT, #__LCD_RS_BIT	;  RS=0
 124  0055 add6          	call	lcd_read_nibble					;   
 125  0057 4e            	swap	A												;   
 126  0058 88            	push	A												;  
 127  0059 9d            	nop														;  250 ns ( 16 MHz)
 128  005a 9d            	nop
 129  005b 9d            	nop
 130  005c 9d            	nop
 131  005d adce          	call	lcd_read_nibble					;   
 132  005f 1a01          	or	A,(1,SP)									;  
 133  0061 5b01          	addw	SP,#1										;   
 134  0063 81            	ret		; ,   A -  
 135                     
 136                     ;    
 137                     ; :     -  A
 138                     ;    A, CC
 139                     ; void _lcd_write_cmd(unsigned char byte)
 140                     	xdef	__lcd_write_cmd
 141  0064               __lcd_write_cmd:		
 142  0064 89            	pushw	X									;    X
 143  0065 88            	push	A
 144  0066               _lcd_write_cmd_2:
 145  0066 ae0002        	ldw	X,#2								;  20 
 146  0069 cd0000        	call	__delay_us10				; 
 147  006c ade3          	call	__lcd_read_status	;   
 148  006e a480          	and	A,#$80							;   
 149  0070 26f4          	jrne	_lcd_write_cmd_2	;   -    
 150  0072               _lcd_write_cmd_1:
 151  0072 721f5014      	bres __LCD_RS_PORT, #__LCD_RS_BIT	;  ,  RS=0
 152  0076 7b01          	ld	A,(1,SP)									;   
 153  0078 4e            	swap	A								;   
 154  0079 ad85          	call lcd_write_nibble ;   
 155  007b 7b01          	ld	A,(1,SP)					;   
 156  007d ad81          	call	lcd_write_nibble	;   
 157  007f 84            	pop	A
 158  0080 85            	popw	X								;    Y
 159  0081 81            	ret										; 
 160                     
 161                     ;     
 162                     ; :     -  
 163                     ;    A, CC
 164                     ; void _lcd_write_data(unsigned char byte)
 165                     	xdef	__lcd_write_data
 166  0082               __lcd_write_data:		
 167                     									; first hihg nibble, then low nibble
 168  0082 89            	pushw	X									;    Y
 169  0083 88            	push	A
 170  0084               _lcd_write_data_2:
 171  0084 ae0002        	ldw X,#2								;   20 
 172  0087 cd0000        	call	__delay_us10
 173  008a adc5          	call	__lcd_read_status	;  
 174  008c a480          	and	A,#$80								;   
 175  008e 26f4          	jrne	_lcd_write_data_2
 176  0090               _lcd_write_data_1:
 177  0090 721e5014      	bset __LCD_RS_PORT, #__LCD_RS_BIT	;  ,  RS=1
 178  0094 7b01          	ld	A,(1,SP)									;   byte
 179  0096 4e            	swap	A												;   
 180  0097 cd0000        	call lcd_write_nibble 				;   
 181  009a 7b01          	ld	A,(1,SP)									;   byte
 182  009c cd0000        	call	lcd_write_nibble				;   
 183  009f 84            	pop	A
 184  00a0 85            	popw	X												;    Y
 185  00a1 81            	ret														; 
 186                     
 187                     
 188                     ;  
 189                     ; :     () -  A
 190                     ;   A, Y, CC
 191                     	xdef	__lcd_init
 192  00a2               __lcd_init:	; void lcd_init(unsigned char width)
 193  00a2 89            	pushw	X
 194  00a3 b702          	ld	__LCD_X_MAX, A				;     LCD_X_MAX
 195                     	;  ,    
 196                     	;  E - , push-pull, 2MHz, '0'
 197  00a5 721d5014      	bres __LCD_E_PORT, #__LCD_E_BIT		; ODR
 198  00a9 721c5017      	bset __LCD_E_PORT+3, #__LCD_E_BIT ; CR1
 199  00ad 721d5018      	bres __LCD_E_PORT+4, #__LCD_E_BIT ; CR2
 200  00b1 721c5016      	bset __LCD_E_PORT+2, #__LCD_E_BIT ; DDR
 201                     	;  RS - , push-pull, 2MHz, '0'
 202  00b5 721f5014      	bres __LCD_RS_PORT, #__LCD_RS_BIT		; ODR
 203  00b9 721e5017      	bset __LCD_RS_PORT+3, #__LCD_RS_BIT ; CR1
 204  00bd 721f5018      	bres __LCD_RS_PORT+4, #__LCD_RS_BIT ; CR2
 205  00c1 721e5016      	bset __LCD_RS_PORT+2, #__LCD_RS_BIT ; DDR
 206                     	;  R/#W - , push-pull, 2MHz, '0'
 207  00c5 721f5005      	bres __LCD_RW_PORT, #__LCD_RW_BIT		; ODR
 208  00c9 721e5008      	bset __LCD_RW_PORT+3, #__LCD_RW_BIT ; CR1
 209  00cd 721f5009      	bres __LCD_RW_PORT+4, #__LCD_RW_BIT ; CR2
 210  00d1 721e5007      	bset __LCD_RW_PORT+2, #__LCD_RW_BIT ; DDR
 211                     	;    
 212                     	;   4  - (), (push-pull),
 213                     	; (2 MHz), ('0'),   (      )
 214  00d5 a678          	ld	A, #__LCD_DATA_MASK
 215  00d7 ca5003        	or	A, __LCD_DATA_PORT+3 ; CR1
 216  00da c75003        	ld	__LCD_DATA_PORT+3, A
 217                     	
 218  00dd a687          	ld	A, #__LCD_DATA_MASK_NOT
 219  00df c45004        	and	A, __LCD_DATA_PORT+4 ; CR2
 220  00e2 c75004        	ld	__LCD_DATA_PORT+4, A
 221                     	
 222  00e5 a687          	ld	A, #__LCD_DATA_MASK_NOT
 223  00e7 c45002        	and	A, __LCD_DATA_PORT+2 ; DDR
 224  00ea c75002        	ld	__LCD_DATA_PORT+2, A
 225                     	
 226  00ed ae001e        	ldw	X,#30
 227  00f0 cd0000        	call __delay_ms 					;  30 
 228                     
 229  00f3 721f5014      	bres __LCD_RS_PORT, #__LCD_RS_BIT		;  ,  RS=0
 230                     	
 231  00f7 a603          	ld	A, #3								;  8- 
 232  00f9 cd0000        	call lcd_write_nibble		;   
 233                     
 234  00fc ae0005        	ldw	X,#5								;  5 
 235  00ff cd0000        	call __delay_ms						; 
 236                     
 237  0102 a603          	ld	A, #3								;  8- 
 238  0104 cd0000        	call lcd_write_nibble		;   
 239                     
 240  0107 ae000b        	ldw	X, #11							;  110 
 241  010a cd0000        	call	__delay_us10				; 
 242                     	
 243  010d a603          	ld	A, #3								;  8- 
 244  010f cd0000        	call lcd_write_nibble		;    (8- )
 245                     	
 246  0112 ae0004        	ldw	X, #4								;  40 
 247  0115 cd0000        	call	__delay_us10				; 
 248                     	
 249  0118 a602          	ld	A, #2								;  4- 
 250  011a cd0000        	call lcd_write_nibble		;    (8- )
 251                     ;     4- 
 252  011d ae0004        	ldw	X, #4								;  40 
 253  0120 cd0000        	call	__delay_us10				; 
 254                     
 255  0123 a602          	ld	A, #2								; : 2 ,  58
 256  0125 cd0000        	call lcd_write_nibble		;    (4- )
 257  0128 a608          	ld	A, #8								;  
 258  012a cd0000        	call lcd_write_nibble		;   
 259                     	
 260  012d ae0004        	ldw	X, #4								;  40 
 261  0130 cd0000        	call	__delay_us10				; 
 262                     
 263  0133 a600          	ld	A, #0								;  
 264  0135 cd0000        	call lcd_write_nibble		;   
 265  0138 a608          	ld	A, #8	
 266  013a cd0000        	call lcd_write_nibble		;   
 267                     
 268  013d ae0004        	ldw	X, #4								;  40 
 269  0140 cd0000        	call	__delay_us10				; 
 270                     
 271  0143 a600          	ld	A, #0								;  
 272  0145 cd0000        	call lcd_write_nibble		;   
 273  0148 a601          	ld	A, #1
 274  014a cd0000        	call lcd_write_nibble		;   
 275                     
 276  014d ae00a0        	ldw	X, #160							;  1,6 
 277  0150 cd0000        	call	__delay_us10				; 
 278                     
 279  0153 a600          	ld	A, #0								; : ,  
 280  0155 cd0000        	call lcd_write_nibble		;   
 281  0158 a606          	ld	A, #6	
 282  015a cd0000        	call lcd_write_nibble		;   
 283                     	
 284  015d a60c          	ld	A, #$0C							;  ,  
 285  015f cd0064        	call	__lcd_write_cmd		;  
 286                     
 287  0162 a680          	ld	A, #$80							;     00
 288  0164 cd0064        	call	__lcd_write_cmd		;  
 289  0167 3f00          	clr	__LCD_X								;     - 0 ( )
 290  0169 3f01          	clr	__LCD_Y								;   - 0
 291  016b 85            	popw	X
 292  016c 81            	ret											;   
 293                     
 294                     ;     
 295                     ; :  (),  () - XH, XL
 296                     ;  : A, CC
 297                     ; void _lcd_gotoxy(unsigned char X (+3), unsigned char Y(+4))
 298                     	xdef	__lcd_gotoxy
 299  016d               __lcd_gotoxy:	
 300  016d 9e            	ld	A,XH					;  X
 301  016e b102          	cp	A, __LCD_X_MAX			;     . X   
 302  0170 2418          	jruge	_lcd_gotoxy_end ;  -  
 303  0172 9f            	ld	A,XL					;  Y
 304  0173 a101          	cp	A, #1							;	    . Y   
 305  0175 2213          	jrugt	_lcd_gotoxy_end	;  -  
 306  0177 b701          	ld	__LCD_Y, A					;  . Y
 307  0179 4e            	swap A								;    (0-, 40h - )
 308  017a 48            	sll	A									;     40h
 309  017b 48            	sll	A
 310  017c 88            	push	A
 311  017d 9e            	ld	A,XH					;    DDRAM (A=X+Y*40h)
 312  017e 1a01          	or	A,(1,SP)
 313  0180 5b01          	add SP,#1
 314  0182 aa80          	or	A,#$80						;     (80h)
 315  0184 cd0064        	call	__lcd_write_cmd	;     .
 316  0187 9e            	ld	A, XH					;  X
 317  0188 b700          	ld	__LCD_X, A					;  . X
 318  018a               _lcd_gotoxy_end:
 319  018a 81            	ret										;   
 320                     
 321                     ;          . 
 322                     ; :   () -  A
 323                     ;   A, CC
 324                     ; void _lcd_putchar(unsigned char c)
 325                     	xdef	__lcd_putchar
 326  018b               __lcd_putchar:	
 327  018b cd0082        	call	__lcd_write_data	;     
 328  018e 3c00          	inc	__LCD_X							;    . 
 329  0190 b600          	ld	A, __LCD_X					;   LCD_X
 330  0192 b102          	cp	A, __LCD_X_MAX			;      ?
 331  0194 2517          	jrult	_lcd_putchar_end	;   -  
 332  0196 3f00          	clr	__LCD_X							;    
 333  0198 3c01          	inc	__LCD_Y							;	 
 334  019a b601          	ld	A, __LCD_Y					;  
 335  019c a102          	cp	A, #2							;      ?
 336  019e 2503          	jrult	_lcd_putchar_1	;   -    DDRAM
 337  01a0 4f            	clr	A									;  ""
 338  01a1 b701          	ld	__LCD_Y, A					;   Y
 339  01a3               _lcd_putchar_1:
 340  01a3 4e            	swap A								;     DDRAM
 341  01a4 48            	sll	A									;   40h
 342  01a5 48            	sll	A
 343  01a6 ba00          	or	A, __LCD_X					; A=X+Y*40h
 344  01a8 aa80          	or	A,#$80						;    DDRAM
 345  01aa cd0064        	call	__lcd_write_cmd	;    DDRAM
 346  01ad               _lcd_putchar_end:	
 347  01ad 81            	ret										;   
 348                     
 349                     ;     Z-   
 350                     ; :    () -  
 351                     ;   A, X, CC
 352                     ;   X- =0   
 353                     ; unsigned int _lcd_putstr(unsigned char *s)
 354                     	xdef	__lcd_putstr
 355  01ae               __lcd_putstr:	
 356  01ae f6            	ld	A,(X)						;    
 357  01af 4d            	tnz	A								; ?
 358  01b0 2705          	jreq	_lcd_putstr_1	;  -  
 359  01b2 add7          	call	__lcd_putchar		;  
 360  01b4 5c            	incw	X							;     
 361  01b5 20f7          	jra	__lcd_putstr			;   
 362  01b7               _lcd_putstr_1:
 363  01b7 81            	ret									;   
 364                     
 365                     ;         
 366                     ; :   () -  X
 367                     ;   A, X, CC
 368                     ; :  
 369                     ; _lcd_putnum(unsigned int Num)
 370                     	xdef	__lcd_putnum
 371  01b8               __lcd_putnum:
 372  01b8 9089          	pushw	Y
 373  01ba 905f          	clrw	Y
 374  01bc               _lcd_putnum_2:
 375  01bc a60a          	ld	A,#10
 376  01be 62            	div	X,A
 377  01bf 2705          	jreq	_lcd_putnum_1
 378  01c1 88            	push	A
 379  01c2 905c          	incw	Y
 380  01c4 20f6          	jra	_lcd_putnum_2
 381  01c6               _lcd_putnum_1:
 382  01c6 ab30          	add	A, #'0'
 383  01c8 adc1          	call	__lcd_putchar
 384  01ca 905d          	tnzw	Y
 385  01cc 2705          	jreq	_lcd_putnum_end
 386  01ce 905a          	decw	Y
 387  01d0 84            	pop	A
 388  01d1 20f3          	jra	_lcd_putnum_1
 389  01d3               _lcd_putnum_end:
 390  01d3 9085          	popw	Y
 391  01d5 81            	ret
 392                     
 393                     ;       
 394                     ; :   -  
 395                     ;   : A, CC
 396                     ; : 
 397                     ; void _lcd_puthexb(unsigned char b)
 398                     	xdef __lcd_puthexb
 399  01d6               __lcd_puthexb:
 400  01d6 88            	push	A								;    
 401  01d7 4e            	swap	A								;   
 402  01d8 a40f          	and	A, #$0F						;  
 403  01da a10a          	cp	A, #10						;   10?
 404  01dc 2502          	jrult _lcd_puthexb_1	;  - 
 405  01de ab07          	add	A, #7							;  +7 ()
 406  01e0               _lcd_puthexb_1:
 407  01e0 ab30          	add	A, #'0'						;     
 408  01e2 ada7          	call	__lcd_putchar			;  
 409  01e4 84            	pop	A									;   
 410  01e5 a40f          	and	A, #$0F						;   ()
 411  01e7 a10a          	cp	A, #10						;   10?
 412  01e9 2502          	jrult _lcd_puthexb_2	;  - 
 413  01eb ab07          	add	A, #7							;  +7 ()
 414  01ed               _lcd_puthexb_2:
 415  01ed ab30          	add	A, #'0'						;     
 416  01ef ad9a          	call	__lcd_putchar			;  
 417  01f1 81            	ret										;   
 418                     	
 419                     ;       
 420                     ; :   -  
 421                     ;   : A, X, CC
 422                     ; : 
 423                     ; void _lcd_puthexw(unsigned int w)
 424                     	xdef	__lcd_puthexw
 425  01f2               __lcd_puthexw:
 426  01f2 9e            	ld	A, XH					;  
 427  01f3 ade1          	call	__lcd_puthexb	;  
 428  01f5 9f            	ld	A, XL					;  
 429  01f6 adde          	call	__lcd_puthexb	;  
 430  01f8 81            	ret								;   
 431                     
 432                     
 433                     ;  
 434                     ; : 
 435                     ;   A, CC
 436                     ; void _lcd_clear(void)
 437                     	xdef	__lcd_clear
 438  01f9               __lcd_clear:	
 439  01f9 a601          	ld	A,#1							;   
 440  01fb cd0064        	call	__lcd_write_cmd	;  
 441  01fe 3f00          	clr	__LCD_X							;  ""
 442  0200 3f01          	clr	__LCD_Y
 443  0202 81            	ret										;   
 444                     	
 445                     ;   
 446                     ; :     () -  X
 447                     ;   A, X, Y, CC
 448                     ; void _lcd_setuserfont(unsigned char *font) 64 Bytes
 449                     	xdef	__lcd_setucg
 450  0203               __lcd_setucg:
 451  0203 9089          	pushw	Y
 452  0205 a640          	ld	A, #$40						;    CGRAM   0
 453  0207 cd0064        	call	__lcd_write_cmd	;  
 454  020a 90ae0040      	ldw	Y, #64						;   - 64 
 455  020e               _lcd_setucg_1:					;   
 456  020e f6            	ld	A,(X)							;     
 457  020f 5c            	incw	X								;   
 458  0210 cd0082        	call	__lcd_write_data	;   
 459  0213 905a          	decw	Y								;  
 460  0215 26f7          	jrne	_lcd_setucg_1		;      -  
 461  0217 be00          	ldw		X, __LCD_X
 462  0219 cd016d        	call	__lcd_gotoxy			;     
 463  021c 81            	ret										;   
 464                     
 465                     	end
