/* MAIN.C file
 * 
 * Copyright (c) 2002-2005 STMicroelectronics
 */
#include "lcd.h"
#include "delay.h"
#include "stm8s105c6.h"
#include "periph.h"

typedef unsigned char uchar;

//      
extern volatile uchar Sec, Min, Hour, SecFlag, Key;

volatile uchar LastKey;

//   -   (     )
unsigned int Number=0;

//   ,    
void InitKeyboard(void)
{
	/* PE0-PE3 -  - 
		 PD2-PD4 -  -     
	(    )
	*/
	
	PE_DDR&=0xF0; // 
	PE_CR1&=0xF0; //  (   )
	PE_CR2&=0xF0; //      
	
	PD_CR1&=0x63; //   
	PD_CR1|=0x80; // PD7 -  (    )
	PD_CR2&=0x63; //    2 
	PD_DDR|=0x9C; // 
	PD_ODR|=0x9C; //   "1"
	Key=0xFF;	//   
}

//      
uchar WaitKey(void)
{
	while(Key==0xFF);
	return Key;
}

main()
{
	CLK_CKDIVR=0x08;	//    RC- 8 MHz
	InitKeyboard();	//  
	_lcd_init(16);	//  
	_lcd_putstr("Hello World!");	//  
	PD_DDR|=1;	//    
	TIM1_DeInit();	//    TIM1
	TIM1_Init(0, 0, 80, 2000);	//   TIM1
	TIM1_EnableInt(0x01);	//      TIM1
	#asm
	rim	//   
	#endasm
	TIM1_Start();	//  
	while(Sec<2);	//  2 
	_lcd_clear();	//  
	while (1)	//  
	{
		if(SecFlag)	//   
		{
			SecFlag=0;	//    
			PD_ODR^=1;	//  
			_lcd_gotoxy(0,0);	//    0,0
			_lcd_putnum(Hour);	//  
			_lcd_putchar(':');	// 
			_lcd_putnum(Min);	//  
			_lcd_putchar(':');	// 
			_lcd_putnum(Sec);	//  
			_lcd_putstr("   ");	// ""
		}
		_lcd_gotoxy(0,1);	//    2 
		_lcd_putnum(Number);	//   
		_lcd_putstr("   ");	// ""
		if(Key!=0xFF)	//  ?
		{
			if(Key==10) Number/=10; //  "*" -   
			else if(Key==11) Number=0;	//  "#" - 
			else 
			{
				if(Number>=1000)Number%=1000;	//  4 
				Number=Number*10+Key;	//  
			}
			Key=0xFF;	// ""    
		}
	}
}
