;      DS1820
;.equ	CMD_SEARCH_ROM = 0xF0	;      
.equ	CMD_READ_ROM = 0x33	;    
;.equ	CMD_MATCH_ROM = 0x55	;      
.equ	CMD_SKIP_ROM = 0xCC 	;          
;.equ	CMD_ALARM_SEARCH = 0xEC	;  ,    ALARM (    CMD_SERCH_ROM)
.equ	CMD_CONVERT_T = 0x44	;   
.equ	CMD_W_SCRATCHPAD = 0x4E	;     ()
.equ	CMD_R_SCRATCHPAD = 0xBE	;    ()
;.equ	CMD_C_SCRATCHPAD = 0x48	;    EEPROM 
;.equ	CMD_RECALL_EE = 0xB8	;     EEPROM   ALARM
;.equ	CMD_READ_POWER = 0xB4	; ,        

;   
;        
;       , . . DDRx=0 PORTx=0
.equ	wireport = DDRC			;   1-Wire
.equ	wirepin  = PinC;		;    1-Wire
.equ	wirebit  = 7			;    1-Wire

.def	wiretemp = R25			; temp   1-Wire
.def 	wireres	 = R2			;    r0...r15			

; 
.dseg
	buffer:	.byte	9		; 9   				
	CRC:	.byte	1		;  .
.cseg		
; 

delay1us:							
;     1  c   RCALL  RET
; rcall (   )  3 + 1 nop + 4 ret = 8 - 1   8
;    
;    , ,     NOP-
	nop			
	ret			

delay10us:	
;     10 ,   delay1us
; rcall (   )  3 + 12    + 
; (5*(8+1+2)+8+1+1)=55    = 80  = 10 
	push	wiretemp	
	ldi	wiretemp, 6	
delay10us_loop:				
	rcall	delay1us	
	dec	wiretemp	
	brne	delay10us_loop	
	pop	wiretemp	
	nop			
	nop			
	nop			
	ret			

delayus:
;   wiretemp  ,    
;   - wiretemp,      (wiretemp )
	dec	wiretemp
delayus_loop:
	rcall	delay10us
	dec	wiretemp
	brne	delayus_loop
	rcall	delay1us
	rcall	delay1us
ret	




Init_1W:
;         PRESENCE  
;      Z-,   	
	cbi	wireport, wirebit		; 0->DDR = Z-
	sbis	wirepin, wirebit	;   1  
	rjmp	presence_fault		;   -  
	sbi	wireport, wirebit		;     0
	ldi	wiretemp, 48			;   480 
	rcall	delayus			
	cbi	wireport, wirebit		;    1
	ldi	wiretemp, 6				;   60 
	rcall	delayus			
	;     PRESENCE
	ldi	wiretemp, 250			;    - 240 max
presence_wait:
	sbis 	wirepin, wirebit
	rjmp	presence_ok
	rcall	delay1us
	dec	wiretemp
	brne 	presence_wait
presence_fault:
	; PRESENCE  
	clz							;  Z-
	
	;ldi wiretemp,255
	;out ddrC,wiretemp
	;out portC,wiretemp
	
	ret
presence_ok:
	; PRESENCE ,   480 
	sez							;  Z-
	ldi	wiretemp, 48
	rcall	delayus
	ret				


Resive_1W:
;     
;   ,   R0 -  
	ser	wiretemp				; wiretemp, 0xFF
	mov	r0, wiretemp
	
	
Send_1W:
;     
; : R0 -  
; : R0 - ,      
; : R0
; :    0FF,      
	ldi	wiretemp, 8				;    

sw1_next:
	push	Temp1
	in	Temp1, SREG
	push	Temp1				;  , ..   
	
	cli							;  
	sbi	wireport, wirebit	; 1->DDR = 0  						;    0
	rcall	delay1us			; 1  
	ror	r0						;   
	brcc	s0					;   C = 0 -  
	cbi	wireport, wirebit	; 0->DDR = Z-						;   1
s0:
	push	wiretemp
	ldi	wiretemp, 9				;     
								;   ,    13!
sw1_wait:
	rcall	delay1us
	dec	wiretemp
	brne	sw1_wait
	clc	
	sbic	wirepin, wirebit
	sec
	ror	wireres
	ldi	wiretemp, 9
	rcall	delayus				; 90  -  -
	cbi	wireport, wirebit	; 0->DDR = Z-
	pop	wiretemp
	
	pop	Temp1
	out	SREG, Temp1
	pop	Temp1

	dec	wiretemp
	brne 	sw1_next		
	mov	r0, wireres
	ret	


ReadBytes_1W:
;  9   ,  CRC
;  R0  SREG,  X  Z
	clr	wiretemp
	sts	CRC, wiretemp			;  CRC
	ldi	XL, low(Buffer)
	ldi	XH, high(Buffer)
	ldi	wiretemp, 9				; 9 
r1w_next:
	push	wiretemp
	rcall	Resive_1w			;  1 
	; R0= ,   CRC
	st	X+, r0					;   
	rcall	crc8				;   
 	pop	wiretemp
	dec	wiretemp
	brne	r1w_next
	ret

	
CRC8:
;   CRC   1-Wire
;   r0 -  
;   CRC -   
;   Z, R0 
; :    CRC  
	push	r0
	ldi	wiretemp, 8
	mov	wireres,wiretemp
CRC8_loop:
	lds	wiretemp, CRC
	eor	r0, wiretemp
	ror	r0
	mov	r0, wiretemp
	brcc 	zero
	ldi	wiretemp, 0x18
	eor	r0, wiretemp
zero:
	ror	r0
	sts	CRC, r0
	pop	r0
	; 4      r0
	push	r0
	ror	r0
	pop	r0
	ror	r0
	;  
	push	r0
	dec	wireres
	brne 	CRC8_loop
	pop	r0
	lds	r0, CRC
	ret
