.include "m32def.inc"		; Use AtMega32A

; Macro ==========================================
; End macro ==========================================




; RAM ==========================================
	.DSEG
	.def 	Temp1=R16
	.def 	Temp2=R17
	.def 	Temp3=R18
	.def	Flag=R19
	;R25 assigned for 1-wire

	TempDigit:	.byte	3
; End RAM ==========================================




; FLASH
	.CSEG
	.ORG 0
; Reset and Interrupt Vectors ==========================================
	JMP 	RESET 					; Reset Handler
	JMP 	0x00	; EXT_INT0 		; IRQ0 Handler
	JMP 	0x00	; EXT_INT1 		; IRQ1 Handler
	JMP 	0x00	; EXT_INT2 		; IRQ2 Handler
	JMP 	0x00	; TIM2_COMP 	; Timer2 Compare Handler
	JMP 	0x00	; TIM2_OVF 		; Timer2 Overflow Handler
	JMP 	0x00	; TIM1_CAPT 	; Timer1 Capture Handler
	JMP 	TIM1_COMPA 				; Timer1 CompareA Handler
	JMP 	0x00	; TIM1_COMPB 	; Timer1 CompareB Handler
	JMP 	0x00	; TIM1_OVF 		; Timer1 Overflow Handler
	JMP 	0x00	; TIM0_COMP 	; Timer0 Compare Handler
	JMP 	0x00	; TIM0_OVF 		; Timer0 Overflow Handler
	JMP 	0x00	; SPI_STC 		; SPI Transfer Complete Handler
	JMP 	0x00	; USART_RXC 	; USART RX Complete Handler
	JMP 	0x00	; USART_UDRE 	; UDR Empty Handler
	JMP 	0x00	; USART_TXC 	; USART TX Complete Handler
	JMP 	0x00	; ADCC 			; ADC Conversion Complete Handler
	JMP 	0x00	; EE_RDY 		; EEPROM Ready Handler
	JMP 	0x00	; ANA_COMP 		; Analog Comparator Handler
	JMP 	0x00	; TWI 			; Two-wire Serial Interface Handler
	JMP 	0x00	; SPM_RDY 		; Store Program Memory Ready Handler
; End Reset and Interrupt Vectors ==========================================

.include "DS1820.asm"		; Unit for DS18B20


; Interrupts ==========================================
TIM1_COMPA:
	LDI 	R16,0
	OUT 	TCNT1H,R16
	OUT 	TCNT1L,R16

	CALL 	GetTemp
RETI 
; End Interrupts ==========================================




; Reset and Initialization ==========================================
RESET:	
	; Stack Pointer Initialization
	LDI 	R16,HIGH(RAMEND)
	OUT 	SPH,R16 			
	LDI 	R16,LOW(RAMEND)
	OUT 	SPL,R16

	; Variables Init
	LDI		R16,0
	STS 	TempDigit,R16
	STS 	TempDigit+1,R16
	STS 	TempDigit+2,R16
	LDI		Flag,0
	
	; Configure I/O Ports
	LDI 	R16,0xFF
	OUT 	DDRA,R16
	OUT 	DDRB,R16
	LDI		R16,0
	OUT		DDRC,R16
	OUT		PORTC,R16

	; Configure Timer, prescaler 1/256, compare to 0x7A12
	LDI 	R16, (1<<OCIE1A)
	OUT 	TIMSK,R16
	
	LDI 	R16, (1<<CS12)
	OUT 	TCCR1B,R16
	
	LDI 	XL,LOW(0x7A12)
	LDI 	XH,HIGH(0x7A12)
	OUT 	OCR1AH,XH
	OUT 	OCR1AL,XL
	
	LDI 	R16,0
	OUT 	TCNT1H,R16
	OUT 	TCNT1L,R16

	; Enable Interrupts Globally
	SEI
; End Reset and Initialization ==========================================




; Main ==========================================
Main:
	CALL	Display
	JMP		Main
; End Main ==========================================




; Procedure ==========================================
Decoder:
	LDI 	ZL,Low(DcMatrix*2)   
	LDI 	ZH,High(DcMatrix*2)  
	ADD 	ZL,Temp1            
	LDI 	Temp2,0             
    ADC 	ZH,Temp2				

    LPM 	Temp1,Z                     
RET


DcMatrix:
		; hgfedcba   hgfedcba
	.db 0b00111111,0b00000110	;0,1
	.db 0b01011011,0b01001111	;2,3
	.db 0b01100110,0b01101101	;4,5
	.db 0b01111101,0b00000111	;6,7
	.db 0b01111111,0b01101111	;8,9


Delay:
	LDI 	Temp1,0
	LDI 	Temp2,4
Dll: 
	DEC 	Temp1
	BRNE	Dll
	DEC 	Temp2
	BRNE 	Dll
RET


Display:
	LDI 	Temp1,0b00111110
	OUT 	PortB,Temp1			  
	MOV		Temp1,Flag
	ANDI	Temp1,0b01000000
	OUT 	PortA,Temp1     
    CALL 	Delay         

	LDI 	Temp1,0b00111101
	OUT 	PortB,Temp1			  
	LDS 	Temp1,TempDigit+2
    CALL 	Decoder        
	OUT 	PortA,Temp1     
    CALL 	Delay    

	LDI 	Temp1,0b00111011
	OUT 	PortB,Temp1			  
	LDS 	Temp1,TempDigit+1
    CALL 	Decoder
	ORI 	Temp1,0b10000000                
	OUT 	PortA,Temp1     
    CALL 	Delay       

	LDI 	Temp1,0b00110111
	OUT 	PortB,Temp1			  
	LDS 	Temp1,TempDigit
    CALL 	Decoder        
	OUT 	PortA,Temp1     
    CALL 	Delay

	LDI 	Temp1,0b00101111
	OUT 	PortB,Temp1			  
	LDI		Temp1,0b01100011
	OUT 	PortA,Temp1     
    CALL 	Delay

	LDI 	Temp1,0b00011111
	OUT 	PortB,Temp1			  
	LDI		Temp1,0b00111001
	OUT 	PortA,Temp1     
    CALL 	Delay
RET


GetTemp:
	; Reset 1-wire
	CALL	Init_1W
	; Skip address
	LDI		Temp1,CMD_SKIP_ROM		
	MOV		R0, Temp1
	CALL	Send_1W		
	; Read ScratchPad
	LDI		Temp1,CMD_R_SCRATCHPAD	
	MOV		R0, Temp1
	CALL	Send_1W			
	; Read bytes
	CALL	ReadBytes_1w
	; Reset 1-wire
	CALL	Init_1W				
	; Skip address
	LDI		Temp1,CMD_SKIP_ROM		
	MOV		R0, Temp1
	CALL	Send_1W		
	; Convert temperature
	LDI	Temp1,CMD_CONVERT_T		;  " "
	MOV		R0, Temp1
	CALL	Send_1W		


	LDI 	Temp1,0
	STS 	TempDigit,Temp1
	STS 	TempDigit+1,Temp1
	STS 	TempDigit+2,Temp1
	ANDI	Flag,0b10111111		

;  
	LDS		Temp2,Buffer		; Load LS
	LDS		Temp1,Buffer+1		; Load MS

	
	CPI 	Temp1,0x08			
	BRCS 	IsPlus				
	NEG 	Temp2
	COM 	Temp1
	ORI		Flag,0b01000000

IsPlus:

	ANDI 	Temp2, ~(0x0F)
	OR 		Temp2, Temp1
	SWAP 	Temp2

	LDI		Temp1, 0
IntLoop:
	CPI		Temp2,10
	BRLO	IntNext
	SUBI	Temp2,10
	INC		Temp1
	JMP		IntLoop	
IntNext:
	STS		TempDigit+2,Temp1
	STS		TempDigit+1,Temp2

	
	; Frac
	LDS		Temp1,Buffer		; Load LS
	ANDI	Temp1,~(0xF0)

	LDI		Temp2,0x71
	MOV		R5,Temp2
	LDI		Temp2,0x02
	MOV		R6,Temp2

	LDI		Temp2,0

	; Multiple to 0625
FracLoop1:
	DEC		Temp1
	BRMI	FracNext1
	ADD		Temp2,R5
	ADC		Temp3,R6
	JMP		FracLoop1
FracNext1:
	
	MOV		XL,Temp2
	MOV		XH,Temp3

	LDI		YL,LOW(1000)
	LDI		YH,HIGH(1000)
	LDI		Temp1,0
	;;CLR		Temp3
FracLoop2:
	SUB		XL,YL
	SBC		XH,YH
;;	CP		XL,Temp3
;;	CPC		XH,Temp3

	BREQ	FracNext2
	INC		Temp1
	JMP		FracLoop2		
FracNext2:
inc temp1
	STS		TempDigit,Temp1


GetTempExit:
ret
; End Procedure ==========================================



;	LDI		YL,LOW(1000)
;	LDI		YH,HIGH(1000)
;	LDI		Temp1,10
	;;CLR		Temp3
;FracLoop2:
;	SUB		XL,YL
;	SBC		XH,YH
;;	CP		XL,Temp3
;;	CPC		XH,Temp3

;	BRLO	FracNext2
;	DEC		Temp1
;	JMP		FracLoop2		
;FracNext2:
;	CPI		Temp1,10
;	BRNE	Final
;	LDI		Temp1,0
;Final:
;	STS		TempDigit,Temp1

