/* ----------------------------------------------------------------------- */
/* --------------- PIC16F887 soldering station with hot air -------------- */
/* --------------------- Author: Alexey Grachov -------------------------- */
/* ---------------------------- gav@bmstu.ru ----------------------------- */
/* ----------------------------------------------------------------------- */
#define PIC16F887
#define LANG_RU
//#define DEBUG
//#define _3V


#ifdef PIC16F887
#define PIC16F88x
#include "pic16f887.h"
#endif

#ifdef PIC16F886
#define PIC16F88x
#include "pic16f886.h"
#endif

#ifdef PIC16F877
#include "pic16f877.h"
#define PIC16F87x
#endif

#ifdef PIC16F876
#include "pic16f876.h"
#define PIC16F87x
#endif

#ifdef PIC16F877a
#include "pic16f877a.h"
#define PIC16F87xa
#endif

#ifdef PIC16F876a
#include "pic16f876a.h"
#define PIC16F87xa
#endif

#define rst 	RC7
#define cs 	RC6
#define sda 	RC5
#define sclk 	RC4
#define led	RC3

#define iron	RC2
#define ironA	RA0
#define ironT	TRISA0
#define ironAD	0x80

#define hotAir	RC0
#define hotAirA	RA1
#define hotAirT	TRISA1
#define hotAirSwitch	RA2
#define hotAirSwitchT	TRISA2
#ifdef PIC16F88x
#define hotAirAD	0x84
#define hotAirSwitchAN	ANS2
#else
#define hotAirAD	0x88
#endif

#define fanT	TRISC1
#define fan	RC1

#define eelcd	0x41
#define eeprog	0x3C

#define BUTTONS PORTB
#define IP	RB0
#define IM	RB1
#define HAP	RB2
#define HAM	RB3
#define FP	RB4
#define FM	RB5
#define ION	RB6
#define HAON	RB7

#define IronMax 400
#define IronMin 0
#define HotAirMax 500
#define HotAirMin 0
#define FanMax 100
#define FanMin 0

// set output pins for lcd here

#define CMD	0
#define DATA	1

#define WIDTH	6
#define HEIGHT	1
#define MID_WIDTH	12
#define MID_HEIGHT	2

typedef unsigned int word;
#ifdef		PIC16F88x
word __at _CONFIG1 CONFIG1 = _INTRC_OSC_NOCLKOUT & _WDT_ON & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _IESO_OFF & _FCMEN_OFF & _LVP_OFF & _DEBUG_OFF;
word __at _CONFIG2 CONFIG2 = _BOR21V & _WRT_OFF;
#endif
#ifdef		PIC16F87x
word __at 0x2007 CONFIG = _HS_OSC & _WDT_ON & _PWRTE_ON & _BODEN_ON & _LVP_OFF & _CPD_OFF & _WRT_ENABLE_OFF & _DEBUG_OFF & _CP_OFF;
#endif
#ifdef		PIC16F87xa
word __at 0x2007 CONFIG = _HS_OSC & _WDT_ON & _PWRTE_ON & _BODEN_ON & _LVP_OFF & _CPD_OFF & _WRT_OFF & _DEBUG_OFF & _CP_OFF;
#endif

void delay_s(unsigned char count);
void Lcd_Init(void);
void Lcd_Write(unsigned char cd,unsigned char c);
void Lcd_Clear(void);
void SetX(unsigned char x);
void SetY(unsigned char y);
//void Lcd_Char(unsigned char sym, unsigned char x);
void EE_Char(unsigned char eesym, unsigned char x, unsigned char y);
void EE_Dec(unsigned int val, unsigned char x, unsigned char y);
void EE_Dec_Small(unsigned char val, unsigned char x, unsigned char y);


unsigned char EERead(unsigned char addr);
void EEReadInt(unsigned int * val, unsigned char adr);
void EEWrite(unsigned char * val, unsigned char adr);
unsigned int ADC_Get(unsigned char ch);
unsigned char Dec(unsigned char val, unsigned char dec, unsigned char position);
void EE_Char_Mid(unsigned char eesym, unsigned char x, unsigned char y);
void EE_Char_Small(unsigned char eesym, unsigned char x, unsigned char y);
void EEWriteMenu(unsigned char x, unsigned char y, unsigned char msg, unsigned char len);

void ON_OFF(unsigned char selected, unsigned char y, unsigned char width);

typedef unsigned char eeprom; 
__code eeprom __at 0x2100 __EEPROM[] = { 
0x3E, 0x51, 0x49, 0x45, 0x3E,// 0
0x00, 0x42, 0x7F, 0x40, 0x00,// 1
0x42, 0x61, 0x51, 0x49, 0x46,// 2
0x21, 0x41, 0x45, 0x4B, 0x31,// 3
0x18, 0x14, 0x12, 0x7F, 0x10,// 4
0x27, 0x45, 0x45, 0x45, 0x39,// 5
0x3C, 0x4A, 0x49, 0x49, 0x30,// 6
0x01, 0x71, 0x09, 0x05, 0x03,// 7
0x36, 0x49, 0x49, 0x49, 0x36,// 8
0x06, 0x49, 0x49, 0x29, 0x1E,// 9
0x00, 0x00, 0x00, 0x00, 0x00,// пробел
0x00, 0x08, 0x08, 0x08, 0x00,
// Stored temperature values
0xB4, 0x00, 0x0E, 0x01, 0x32,

0x20, // write VOP register __EEPROM[41]
#ifdef _3V
0x90,
#else
0x80,
#endif
0xA4, // all on/normal display
0x2F, // Power control set(charge pump on/off)
0x40, // set start row address = 0
0xB0, // set Y-address = 0
0x10, // set X-address, upper 3 bits
0x00,  // set X-address, lower 4 bits
#ifdef DEBUG
0xC8, // mirror Y axis (about X axis)
#else
0xC0, // !mirror Y axis (about X axis)
#endif
0xA0, // !Invert screen in horizontal axis
//0xA1, // Invert screen in horizontal axis
0xAC, // set initial row (R0) of the display
0x07,
//Lcd_Write(CMD,0xF9); // 
0xAF, // display ON/OFF

#ifdef LANG_RU
// <уст>
// < 
0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x00,
// 0x1D - 'У'.
0x27, 0x48, 0x48, 0x48, 0x3f, 0x00,
// 0x1B - 'С'.
0x3e, 0x41, 0x41, 0x41, 0x22, 0x00,
// 0x1C - 'Т'.
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// >
0x00, 0x7F, 0x3E, 0x1C, 0x08, 0x00,
// <тек>
// < 
0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x00,
// 0x1C - 'Т'.
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// 0xf - 'Е'.
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x14 - 'К'.
0x7f, 0x08, 0x14, 0x22, 0x41, 0x00,
// >
0x00, 0x7F, 0x3E, 0x1C, 0x08, 0x00,

// 0x19 - 'П'
0x7f, 0x01, 0x01, 0x01, 0x7f, 0x00,
// 0xa - 'А'
0x7e, 0x11, 0x11, 0x11, 0x7e, 0x00,
// 0x29 - 'Я'
0x66, 0x19, 0x09, 0x09, 0x7f, 0x00,
// 0x15 - 'Л'
0x40, 0x7e, 0x01, 0x01, 0x7f, 0x00,
// 0x26 - 'Ь'
0x7f, 0x48, 0x48, 0x48, 0x30, 0x00,
// 0x17 - 'Н'
0x7f, 0x08, 0x08, 0x08, 0x7f, 0x00,
// 0x12 - 'И'
0x7f, 0x20, 0x10, 0x08, 0x7f, 0x00,
// 0x14 - 'К'
0x7f, 0x08, 0x14, 0x22, 0x41, 0x00,

// 0x1E - 'Ф'
0x0e, 0x11, 0x7f, 0x11, 0x0e, 0x00,
// 0xf - 'Е'
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x17 - 'Н'
0x7f, 0x08, 0x08, 0x08, 0x7f, 0x00,

// 0x18 - 'О'.
0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00,
// 0xb - 'Б'.
0x7f, 0x49, 0x49, 0x49, 0x31, 0x00,
// 0x18 - 'О'.
0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00,
// 0x1A - 'Р'.
0x7f, 0x09, 0x09, 0x09, 0x06, 0x00,
// 0x18 - 'О'.
0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00,
// 0x1C - 'Т'.
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// 0x25 - 'Ы'.
0x7f, 0x48, 0x48, 0x30, 0x7f, 0x00,
// % 
0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
#else
// <set>
// < 
0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x00,
// 0x1D - 'S'.
0x46, 0x49, 0x49, 0x49, 0x31, 0x00,
// 0x1B - 'E'.
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x1C - 'T'.
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// >
0x00, 0x7F, 0x3E, 0x1C, 0x08, 0x00,
// <get>
// < 
0x00, 0x08, 0x1C, 0x3E, 0x7F, 0x00,
// 0x1C - 'G'.
0x3E, 0x41, 0x41, 0x51, 0x32, 0x00,
// 0xf - 'E'.
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x14 - 'T'.
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// >
0x00, 0x7F, 0x3E, 0x1C, 0x08, 0x00,

// 0x19 - 'I'
0x00, 0x41, 0x7F, 0x41, 0x00, 0x00,
// 0xa - 'R'
0x7F, 0x09, 0x19, 0x29, 0x46, 0x00,
// 0x29 - 'O'
0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00,
// 0x15 - 'N'
0x7F, 0x04, 0x08, 0x10, 0x7F, 0x00,

// 0x26 - 'H'
0x7F, 0x08, 0x08, 0x08, 0x7F, 0x00,
// 0x29 - 'O'
0x3e, 0x41, 0x41, 0x41, 0x3e, 0x00,
// 0x12 - 'T'
0x01, 0x01, 0x7f, 0x01, 0x01, 0x00,
// 0x14 - 'A'
0x7E, 0x11, 0x11, 0x11, 0x7E, 0x00,
// 0x1E - 'I'
0x00, 0x41, 0x7F, 0x41, 0x00, 0x00,
// 0xa - 'R'
0x7F, 0x09, 0x19, 0x29, 0x46, 0x00,

// 0x18 - 'S'.
0x46, 0x49, 0x49, 0x49, 0x31, 0x00,
// 0x1A - 'Р'.
0x7F, 0x09, 0x09, 0x09, 0x06, 0x00,
// 0x18 - 'E'.
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x1C - 'E'.
0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
// 0x25 - 'D'.
0x7F, 0x41, 0x41, 0x22, 0x1C, 0x00,

// % 
0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
// % 
0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
// % 
0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
// % 
0x23, 0x13, 0x08, 0x64, 0x62, 0x00,
#endif

};

typedef union {
	struct {
	  unsigned char :1;
	  unsigned char :1;
	  unsigned char :1;
	  unsigned char :1;
	  unsigned char SAVE:1;
	  unsigned char SHOW:1;
	  unsigned char HOTAIR:1;
	  unsigned char IRON:1;
	};
} __SS_bits_t;
__SS_bits_t SS_bits;

#define SAVE		SS_bits.SAVE
#define SHOW		SS_bits.SHOW
#define HOTAIR		SS_bits.HOTAIR
#define IRON		SS_bits.IRON

unsigned char conv[16] = {0x00, 0x03, 0x0C, 0x0F, 0x30, 0x33, 0x3C, 0x3F, 0xC0, 0xC3, 0xCC, 0xCF, 0xF0, 0xF3, 0xFC, 0xFF}; // 10x14

unsigned char i,j,k,dec,bt_delay,on_off_delay,sec,show,status_temp,w_temp,fan_speed, fan_defaults, min, hour, sleep;
unsigned int itemp, prog[2], defaults[2];


void isr() __interrupt 0 {
	GIE=0;
		if (TMR2IE && TMR2IF) {
			if (bt_delay) bt_delay--;
			if (on_off_delay) on_off_delay--;
			if (sec++>15) {
				__asm
				CLRWDT
				__endasm;
				sec=0;
				min--;
				if (!min) {
					min=0xCC;
					hour--;
					if (!hour) sleep=1;
				}
				SHOW=1;
			}
			if (!bt_delay && BUTTONS!=0x3F) {
				if (!IP) {
					if (prog[0]>IronMax-1)
						prog[0]=IronMax;
					else
						prog[0]++;
				}
				if (!IM) {
					if (prog[0]<IronMin+1)
						prog[0]=0;
					else
						prog[0]--;
				}
				if (!HAP) {
					if (prog[1]>HotAirMax-1)
						prog[1]=HotAirMax;
					else
						prog[1]++;
				}
				if (!HAM) {
					if (prog[1]<HotAirMin+1)
						prog[1]=0;
					else
						prog[1]--;
				}
				if (!FP) {
					if (fan_speed>FanMax-1)
						fan_speed=FanMax;
					else
						fan_speed++;
					CCPR2L=fan_speed+20;
				}
				if (!FM) {
					if (fan_speed<FanMin+1)
						fan_speed=0;
					else
						fan_speed--;
					CCPR2L=fan_speed+20;
				}
				bt_delay=10;
			}
			SHOW=1;
		}

		if (RBIF) {

			if (sleep) {
				min=0xCC;
				hour=0x78;
				sleep=0;
			}
			else
				if (!on_off_delay && BUTTONS!=0x3F) {
					if (!ION) {
						IRON=!IRON;
					}
					if (!HAON) {
						HOTAIR=!HOTAIR;
					}
					if (!IRON || !HOTAIR) 
						if (defaults[0]!=prog[0] || defaults[1]!=prog[1] || fan_defaults!=fan_speed) SAVE=1;
					on_off_delay=30;
				}
			SHOW=1;

		}
	TMR2IF=RBIF=0;
	GIE=1;
}

void main() {
unsigned char * pt;

	sleep=1;

	PORTB=0;
	PORTC=0;
	TRISC=0;

#ifdef PIC16F88x
	WDTCON=0x0A;
	ANSELH=0;
	IOCB=WPUB=0xFF;
	hotAirSwitchAN=0;
#else
	PCFG2=1;
#endif

	TRISB=0xFF;	//PORTB<0:5> input
	NOT_RBPU=0;	// Enable pull-ups

	ADFM=1;
	hotAirSwitchT=1;
	ironT=hotAirT=1;
	ironA=hotAirA=1;
//	led=1;
//	delay_s(5);
	Lcd_Init();
	
	for (i=0;i<4;i++) {
		pt = (unsigned char *)(&prog[0])+i;
		*pt = EERead(eeprog+i);
		defaults[0] = *pt;
	}
	fan_defaults=fan_speed=EERead(eeprog+i);

	// УСТ
	EEWriteMenu(2*WIDTH+4,0,0x4E,5);
	// ТЕК
	EEWriteMenu(10*WIDTH+4,0,0x6B,5);
#ifdef LANG_RU
	EEWriteMenu(WIDTH,HEIGHT,0x89,8);
	EEWriteMenu(WIDTH,4*HEIGHT,0xB9,3);
	EEWriteMenu(WIDTH,7*HEIGHT,0xCB,7);
	EEWriteMenu(15*WIDTH,7*HEIGHT,0xF5,1);
#else
	// IRON
	EEWriteMenu(WIDTH,HEIGHT,0x89,4);
	// HOTAIR
	EEWriteMenu(WIDTH,4*HEIGHT,0xA1,6);
	// SPEED
	EEWriteMenu(WIDTH,7*HEIGHT,0xC5,5);
	EEWriteMenu(15*WIDTH,7*HEIGHT,0xF5,1);
#endif
	PEIE=1;
	TMR2IE=1;
	RBIE=0;

	TMR2IF=RBIF=0;
	T2CON=0x7F; // Timer2 prescaler=1:16 postscaler=1:16 on

	bt_delay=sec=0;
	IRON=HOTAIR=SAVE=0;
	SHOW=1;
//	EE_Dec(250,0);
// PWM module configuration
	fanT=1;
	CCP2CON=0;
	PR2=0x85;
	CCPR2L=fan_speed+20;
	fanT=0;
//	TRISC1=0;
	GIE=1;
//	while (1) ;		
	while (1) {
		if (SHOW) {
			if (sleep) {
				IRON=0;
				HOTAIR=0;
				led=0;
			}
			else led=1;
			// Iron
			itemp=ADC_Get(ironAD);
			itemp>>=1;
			EE_Dec(prog[0],0,2);
			if (IRON) {
				if (itemp>prog[0]) iron=0; else iron=1;
			} else {
				iron=0;
			}
			EE_Dec(itemp,4,2);
			#ifdef LANG_RU
				ON_OFF(IRON, 1, 9);
			#else
				ON_OFF(IRON, 1, 5);
			#endif
			// Hot Air
			itemp=ADC_Get(hotAirAD);
			itemp>>=1;
			EE_Dec(prog[1],0,5); 
			if (HOTAIR && hotAirSwitch) {
				if (itemp>prog[1]) hotAir=0; else hotAir=1;
				CCP2CON=0x0F;
			}
			else {
				hotAir=0;
				if (itemp<30) { CCP2CON=0; fan=0;}
				else if (itemp>50) CCP2CON=0x0F;
			}
			EE_Dec(itemp,4,5);
			#ifdef LANG_RU
				ON_OFF(HOTAIR, 4, 4);
			#else
				ON_OFF(HOTAIR, 4, 7);
			#endif
			// Fan speed
			EE_Dec_Small(fan_speed,12,7);
//	EE_Dec(1,0);
		SHOW=0;
//		led=!led;
				if (SAVE) {
					for (i=0;i<4;i++) {
						EEWrite( (unsigned char *)(&prog[0])+i, (eeprog+i));
					}
					EEWrite(&fan_speed, eeprog+4);
					SAVE=0;
				}
		}
	}
} 

void EEWriteMenu(unsigned char x, unsigned char y, unsigned char msg, unsigned char len) {
	SetX(x);
	SetY(y);
	for (i=0;i<6*len;i++)
		Lcd_Write(DATA,EERead(msg+i));
	return;
}

void ON_OFF (unsigned char selected, unsigned char y, unsigned char w) {
unsigned char sym;
	SetX(0);
	SetY(y);
	for (i=0; i<6; i++) {
		if (selected) sym=EERead(0x65+i); else sym=0x00;
		Lcd_Write(DATA, sym);
	}
	SetX(WIDTH*w);
	for (i=0; i<6; i++) {
		if (selected) sym=EERead(0x4E+i); else sym=0x00;
		Lcd_Write(DATA,sym);
	}
	return;
}

unsigned char EERead(unsigned char adr) {
	EEADR=adr;
	RD=1;
	return EEDATA;
}

void EEWrite(unsigned char * val, unsigned char adr) {
	EEADR=adr;
	EEDATA=*val;
	EEPGD=0;
	EEIF=0;
	WREN=1;
	while (GIE=0);
	EECON2=0x55;
	EECON2=0xAA;
	WR=1;
	GIE=1;
	while (!EEIF);
	WREN=0;
	return;
}

// void EEReadInt(unsigned int * val, unsigned char adr) {
// 	*val=EERead(adr);
// 	*val<<=8;
// 	*val+=EERead(adr+1);
// 	return;
// }

void delay_s(unsigned char count) {
unsigned char i,j,k;

	for (i=0;i<count;i++)
		for (j=0;j<100;j++)
			for (k=0;k<100;k++) ;
	return;
}

//clear LCD
void Lcd_Clear(void){

SetX(0);
SetY(0);
Lcd_Write(CMD,0xAE); // disable display;
for(i=0;i<12;i++)
	for(j=0;j<72;j++)
Lcd_Write(DATA,0x00);
Lcd_Write(CMD,0xAF); // enable display;
	return;
}

// init LCD
void Lcd_Init(void){
cs = 0;
rst = 0;
delay_s(20);			// 5mS so says the stop watch(less than 5ms will not work)
rst = 1;
for (i=eelcd;i<eelcd+0x0D;i++) {
	Lcd_Write(CMD,EERead(i));
//	led=!led;
}

Lcd_Clear(); // clear LCD
Lcd_Write(CMD,0xA6); // invert display
delay_s(5);				// 1/2 Sec delay
return;
}

unsigned int ADC_Get(unsigned char cfg) {
unsigned int res;
	ADCON0 = cfg;
	delay_s(1);
	ADON=1;
	delay_s(1);
	GO_DONE=1;	
	while(GO_DONE);
	ADON=0;
	res=ADRESH;
	res<<=8;
	res+=ADRESL;
	return	res;
}

void Lcd_Write(unsigned char cd,unsigned char c){
unsigned char li;
	cs = 0;
	sclk = 0;
	sda = cd;
	sclk = 1;

for(li=0;li<8;li++){
		sclk = 0;
			if(c & 0x80)
				sda = 1;
			else
				sda = 0;
		sclk = 1;
		c <<= 1;
//		Delay10TCYx(20);
				}
		sclk=0;
		sda=0;
		cs = 1;
	return;
}


void SetX(unsigned char x){
	Lcd_Write(CMD,x & 0x0F);
	Lcd_Write(CMD,0x10 | ((x>>4)&0xF));
	return;
}

void SetY(unsigned char y){
	Lcd_Write(CMD,0xB0 + y);
	return;
}

// void EE_Char(unsigned char eesym, unsigned char x, unsigned char y) {
// 
// 	unsigned char line,sym;
// 	
// 	SetX(6*x);
// 	SetY(y);
// 	for(line=0;line<5;line++) {
// 		sym=EERead(eesym*5+line);
// 		Lcd_Write(DATA, sym);
// 	}
// 	
// return;
// }

void EE_Char(unsigned char eesym, unsigned char x, unsigned char y) {
unsigned char line, ch, sym;

	for(line=0;line<5;line++) {
		sym=EERead((eesym<<2)+eesym+line);
		for (i=0;i<4;i++) {
				sym>>=1;
					ch = (C) ? 0x0F : 0x00;
				sym>>=1;
					ch += (C) ? 0xF0 : 0x00;
				SetY(i+(y<<2));
				SetX((x*24)+(line<<2));
				for (j=0;j<4;j++)
					Lcd_Write(DATA, ch);
//		Lcd_Write(DATA,0xFF);
			}
	}
return;
}

void EE_Char_Mid(unsigned char eesym, unsigned char x, unsigned char y) {
	unsigned char line,sym, j;
	
	for (line=0;line<5;line++) {
		SetX(x);
		SetY(y);

		sym=EERead(eesym*5+line);
		for(j=0;j<2;j++)
			Lcd_Write(DATA, conv[sym&0x0F]);
		SetX(x);
		SetY(++y);
		for(j=0;j<2;j++)
			Lcd_Write(DATA, conv[sym>>4]);
		y--;
		x+=2;
	}

return;
}

void EE_Char_Small(unsigned char eesym, unsigned char x, unsigned char y) {
	unsigned char line,sym;
	
	SetX(x);
	SetY(y);

	for (line=0;line<5;line++) {

		sym=EERead(eesym*5+line);
		Lcd_Write(DATA, sym);
	}

return;
}
void EE_Dec(unsigned int val, unsigned char x, unsigned char y) {
unsigned int k;
unsigned char show;
	if (val<50) {
		EE_Char_Mid(0x0A,x*MID_WIDTH,y*HEIGHT);
		EE_Char_Mid(0x0B,(++x)*MID_WIDTH,y*HEIGHT);
		EE_Char_Mid(0x0B,(++x)*MID_WIDTH,y*HEIGHT);
		EE_Char_Mid(0x0B,(++x)*MID_WIDTH,y*HEIGHT);
		return;
	}
	show=0;
	k=val/1000;
	if (k) show=1;
	val=val-k*1000;
	if (!show) k=10;
	EE_Char_Mid(k,x*MID_WIDTH,y*HEIGHT);
	k=val/100;
	if (k) show=1;
	val=val-k*100;
	if (!show) k=10;
	EE_Char_Mid(k,(++x)*MID_WIDTH,y*HEIGHT);
	k=val/10;
	if (k) show=1;
	val=val-k*10;
	if (!show) k=10;
	EE_Char_Mid(k,(++x)*MID_WIDTH,y*HEIGHT);
	EE_Char_Mid(val,(++x)*MID_WIDTH,y*HEIGHT);
return;
}

void EE_Dec_Small(unsigned char val, unsigned char x, unsigned char y) {
unsigned int k;
unsigned char show;
// 	if (val<50) {
// 		EE_Char_Mid(0x0B,1,position);
// 		EE_Char_Mid(0x0B,2,position);
// 		EE_Char_Mid(0x0B,3,position);
// 		return;
// 	}
	show=0;
	k=val/100;
	if (k) show=1;
	val=val-k*100;
	if (!show) k=10;
	EE_Char_Small(k,x*WIDTH,y*HEIGHT);
	k=val/10;
	if (k) show=1;
	val=val-k*10;
	if (!show) k=10;
	EE_Char_Small(k,(++x)*WIDTH,y*HEIGHT);
	EE_Char_Small(val,(++x)*WIDTH,y*HEIGHT);
return;
}