#include <nxp/iolpc1768.h>
#include "lcd.h"

#define POWCTL			0xF3
#define VCMCTL			0xF4
#define SRCCTL			0xF5
#define SLPOUT			0x11
#define TEON			0x35
#define MADCTL			0x36
#define COLMOD			0x3A
#define DISCTL			0xF2
#define IFCTL			0xF6
#define GATECTL			0xFD
#define WRDISBV			0x51
#define WRCABCMB		0x5E
#define MIECTL1			0xCA
#define BCMODE			0xCB
#define MIECTL2			0xCC
#define MIECTL3			0xCD
#define RPGAMCTL		0xF7
#define RNGAMCTL		0xF8
#define GPGAMCTL		0xF9
#define GNGAMCTL		0xFA
#define BPGAMCTL		0xFB
#define BNGAMCTL		0xFC
#define CASET			0x2A
#define PASET			0x2B
#define RAMWR                   0x2C
#define WRCTRLD			0x53
#define WRCABC			0x55
#define DISPON			0x29
#define DISPOFF			0x28
#define SLPIN			0x10
#define RDDIDIF			0x04		// 4 parameters
#define	RDID1			0xDA		// 2 parameters
#define	RDID2			0xDB		// 2 parameters
#define	RDID3			0xDC		// 2 parameters





static struct setting_table power_on_setting_table[] = {
	{   POWCTL,  7, { 0x80, 0x00, 0x00, 0x0B, 0x33, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },
	{   VCMCTL,  5, { 0x6E, 0x6E, 0x7F, 0x7F, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },
	{   SRCCTL,  5, { 0x12, 0x00, 0x03, 0xF0, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },
	{   SLPOUT,  0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }, 120 },
	{   MADCTL,  1, { 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },	
	{   COLMOD,  1, { 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  30 },	
	{   DISCTL, 11, { 0x14, 0x14, 0x03, 0x03, 0x04, 0x03, 0x04, 0x10, 0x04, 0x14, 0x14, 0x00, 0x00, 0x00, 0x00 },   0 },	
	{  GATECTL,  2, { 0x22, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },	
	{  WRDISBV,  1, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 }, //BRIGHTNESS	
	{ WRCABCMB,  1, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   0 },	
	{  MIECTL1,  3, { 0x80, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{   BCMODE,  1, { 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{  MIECTL2,  3, { 0x20, 0x01, 0x8F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{  MIECTL3,  2, { 0x7C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{ RPGAMCTL, 15, { 0x00, 0x23, 0x15, 0x15, 0x1C, 0x19, 0x18, 0x1E, 0x24, 0x25, 0x25, 0x20, 0x10, 0x22, 0x21 },   0 },	
	{ RNGAMCTL, 15, { 0x19, 0x00, 0x15, 0x15, 0x1C, 0x1F, 0x1E, 0x24, 0x1E, 0x1F, 0x25, 0x20, 0x10, 0x22, 0x21 },   0 },	
	{ GPGAMCTL, 15, { 0x06, 0x23, 0x14, 0x14, 0x1D, 0x1A, 0x19, 0x1F, 0x24, 0x26, 0x30, 0x1E, 0x1E, 0x22, 0x21 },   0 },	
	{ GNGAMCTL, 15, { 0x19, 0x06, 0x14, 0x14, 0x1D, 0x20, 0x1F, 0x25, 0x1E, 0x20, 0x30, 0x1E, 0x1E, 0x22, 0x21 },   0 },	
	{ BPGAMCTL, 15, { 0x2C, 0x23, 0x20, 0x20, 0x23, 0x2F, 0x30, 0x39, 0x09, 0x09, 0x18, 0x13, 0x13, 0x22, 0x21 },   0 },	
	{ BNGAMCTL, 15, { 0x19, 0x2C, 0x20, 0x20, 0x23, 0x35, 0x36, 0x3F, 0x03, 0x03, 0x18, 0x13, 0x13, 0x22, 0x21 },   0 },	
	{    CASET,  4, { 0x00, 0x00, 0x00, 0xEF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{    PASET,  4, { 0x00, 0x00, 0x01, 0x8F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{    RAMWR,  0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{  WRCTRLD,  1, { 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{   WRCABC,  1, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },	0 },	
	{   DISPON,  0, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },  50 },	
};

void LCDCommand(unsigned char command)
{
    FIO_LCD_RS_CLR = LCD_RS_MASK;
    
    FIO2MASK = 0xFFFFFF00;
    FIO_LCD_DAT_PIN = command;
    FIO2MASK = 0x00000000;
    FIO_LCD_WR_CLR = LCD_WR_MASK;
    FIO_LCD_WR_SET = LCD_WR_MASK;
    
    FIO_LCD_RS_SET = LCD_RS_MASK;
}

void LCDData(unsigned char data)
{
    FIO2MASK = 0xFFFFFF00;
    FIO_LCD_DAT_PIN = data;
    FIO2MASK = 0x00000000;
    FIO_LCD_WR_CLR = LCD_WR_MASK;
    FIO_LCD_WR_SET = LCD_WR_MASK;
}

void LCDData16(unsigned int data)
{
    FIO2MASK = 0xFFFFFF00;
    FIO_LCD_DAT_PIN = data>>8;
    FIO2MASK = 0x00000000;
    FIO_LCD_WR_CLR = LCD_WR_MASK;
    FIO_LCD_WR_SET = LCD_WR_MASK;
    
    FIO2MASK = 0xFFFFFF00;
    FIO_LCD_DAT_PIN = data;
    FIO2MASK = 0x00000000;
    FIO_LCD_WR_CLR = LCD_WR_MASK;
    FIO_LCD_WR_SET = LCD_WR_MASK;
}

/*unsigned char LCDRead()
{
    unsigned char data;
    FIO_LCD_RS_SET = LCD_RS_MASK;
    
    
    FIO2DIR &= ~0x000000FF;
    FIO_LCD_RD_CLR = LCD_RD_MASK;
    //FIO2MASK = 0xFFFFFF00;
    data = FIO_LCD_DAT_PIN;
    data = FIO_LCD_DAT_PIN;
    //FIO2MASK = 0x00000000;
    FIO_LCD_RD_SET = LCD_RD_MASK;
    
    FIO2DIR |= 0x000000FF;
    
    return data;
}*/

void LCDSettingTableWrite(struct setting_table *table)
{
    LCDCommand(table->command);
    if ((table->parameters) > 0)
    {
        for (int i=0; i<(table->parameters); i++)
        {
             LCDData(table->parameter[i]);
        }
    }
    if ((table->wait) > 0) Wait(table->wait);
}

void LCDPowerOn()
{
    for (int i=0; i<(int)(sizeof(power_on_setting_table)/sizeof(struct setting_table)) ; i++)
    {
         LCDSettingTableWrite(&power_on_setting_table[i]);
    }
}