#ifndef __LCD_H 
#define __LCD_H

#define LCD_CS_MASK (1<<11)
#define LCD_RST_MASK (1<<10)
#define LCD_RS_MASK (1<<5)
#define LCD_WR_MASK (1<<4)
#define LCD_RD_MASK (1<<12)

#define FIO_LCD_CS_SET FIO2SET
#define FIO_LCD_CS_CLR FIO2CLR
#define FIO_LCD_RST_SET FIO2SET
#define FIO_LCD_RST_CLR FIO2CLR
#define FIO_LCD_RS_SET FIO0SET
#define FIO_LCD_RS_CLR FIO0CLR
#define FIO_LCD_WR_SET FIO0SET
#define FIO_LCD_WR_CLR FIO0CLR
#define FIO_LCD_RD_SET FIO2SET
#define FIO_LCD_RD_CLR FIO2CLR
#define FIO_LCD_DAT_PIN FIO2PIN

struct setting_table
{
  unsigned char command;
  unsigned char parameters;
  unsigned char parameter[15];
  unsigned int wait;
}; 

extern void Wait(unsigned long delay);
void LCDCommand(unsigned char command);
void LCDData(unsigned char data);
void LCDData16(unsigned int data);
unsigned char LCDRead();
void LCDSettingTableWrite(struct setting_table *table);
void LCDPowerOn();

#endif